/* File:      interrupt2.P
** Author(s): Baoqiu Cui
**
** Test attributed variable interrupt triggered during the execution of
** verify_attributes/2.
** 
** $Id: interrupt2.P,v 1.1 1999-11-02 02:48:57 cbaoqiu Exp $
*/

:- import put_attributes/2, get_attributes/3 from machine.
:- import attv_unify/2 from machine.

test :-
	put_attributes(X, v(a)),
	put_attributes(Y, v(b)),
	p(X,Y),
	write('X = '), writeln(X),
	write('Y = '), writeln(Y).
	
verify_attributes(Var, Value) :-
	get_attributes(Var, Atts, _),
	writeln('In verify_attributes/2:'),
	write('   Var''s attribute = '), writeln(Atts),
	write('   Value = '), writeln(Value),
	(Atts = v(c)
	 ->	attv_unify(Var, Value)	% interrupt caused by the call of t/1
	 ;	put_attributes(X, v(c)),
		t(X),			% trigger another attv interrupt
		attv_unify(Var, X)
	).

% t/1 is called within verify_attributes/2.
t(X) :- X = 7.
	
p(X,Y) :- X = 5, Y = 6.

