## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(gpyramid)
library(ape)
library(dplyr)

## ----r1-----------------------------------------------------------------------
line_df <- data.frame(line = c("x1", "x2", "x3", "x4", "x5", "x6"),
                      gene1 = c("H", "H", "A", "B", "B", "B"),
                      gene2 = c("H", "H", "A", "B", "B", "A"),
                      gene3 = c("H", "H", "B", "A", "A", "A"),
                      gene4 = c("H", "B", "B", "B", "A", "B"),
                      gene5 = c("H", "H", "B", "A", "B", "B"),
                      gene6 = c("B", "A", "B", "A", "B", "B"),
                      gene7 = c("B", "B", "B", "B", "B", "A"))

line_df

## -----------------------------------------------------------------------------
position_df <- data.frame(Gene = c("gene1", "gene2", "gene3", "gene4", "gene5", "gene6", "gene7"),
                          Chr = c("1", "2", "3", "4", "5", "6", "7"),
                          cM = c(20, 0, 40, 20, 10, 0, 0))
position_df

## ----r3-----------------------------------------------------------------------
gene_dat <- util_haplo(line_df, target = "A", non_target = "B", hetero = "H", line_cul = "line")

gene_df1 <- gene_dat[[1]]
gene_df2 <- gene_dat[[2]]
line_id <- gene_dat[[3]]

colnames(gene_df1) <- line_id
colnames(gene_df2) <- line_id

gene_df1
gene_df2

## -----------------------------------------------------------------------------
recom_mat <- util_recom_mat(position_df, "cM")
recom_mat

## -----------------------------------------------------------------------------
line_comb_lis <- findPset(gene_df1, gene_df2, line_id)
line_comb_lis

## -----------------------------------------------------------------------------
cost_rslt <- calcCostAll(line_comb_lis, gene_df1, gene_df2, recom_mat, prob_total = 0.99)
cost_rslt

## -----------------------------------------------------------------------------
cost_all <- cost_rslt$cost_all
plot(x = cost_all$n_parent, y = cost_all$N_total, 
     log = "y", xlab = "Number of generations", ylab = "Number of individuals")

## -----------------------------------------------------------------------------
cost_all[cost_all$N_total < 200,]

## -----------------------------------------------------------------------------
rslt_one <- getFromAll(cost_rslt, cross_id = 13)
summary(rslt_one)
plot(rslt_one$topolo)
nodelabels()

## -----------------------------------------------------------------------------
rslt_one <- getFromAll(cost_rslt, cross_id = 7)
summary(rslt_one)
plot(rslt_one$topolo)
nodelabels()

