## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

options(gtsummary.print_engine = "gt")

## ----setup--------------------------------------------------------------------
# library(sumExtras)
# library(gtsummary)
# library(dplyr)
# 
# use_jama_theme()

## ----setup2-------------------------------------------------------------------
library(sumExtras)
library(gtsummary)
library(dplyr)
library(gt)

use_jama_theme()

## -----------------------------------------------------------------------------
dictionary <- tibble::tribble(
  ~variable,    ~description,
  "trt",        "Chemotherapy Treatment",
  "age",        "Age at Enrollment (years)",
  "marker",     "Marker Level (ng/mL)",
  "stage",      "T Stage",
  "grade",      "Tumor Grade",
  "response",   "Tumor Response",
  "death",      "Patient Died"
)

dictionary

## -----------------------------------------------------------------------------
trial |>
  tbl_summary(by = trt, include = c(age, grade, marker)) |>
  extras() |> 
  add_auto_labels(dictionary = dictionary)

## -----------------------------------------------------------------------------
# dictionary already exists from above
trial |>
  tbl_summary(by = trt, include = c(age, stage, response)) |>
  extras() |> 
  add_auto_labels()

## -----------------------------------------------------------------------------
labeled_trial <- trial
attr(labeled_trial$age, "label") <- "Patient Age at Baseline"
attr(labeled_trial$marker, "label") <- "Biomarker Concentration (ng/mL)"

labeled_trial |>
  tbl_summary(by = trt, include = c(age, marker)) |>
  extras() |> 
  add_auto_labels()

## -----------------------------------------------------------------------------
trial |>
  tbl_summary(
    by = trt,
    include = c(age, grade, marker),
    label = list(age ~ "Age (from tbl_summary function)")
  ) |>
  extras() |> 
  add_auto_labels(dictionary = dictionary)

## -----------------------------------------------------------------------------
lm(marker ~ age + grade + stage, data = trial) |>
  tbl_regression() |>
  add_auto_labels()

## -----------------------------------------------------------------------------
trial_both <- trial
attr(trial_both$age, "label") <- "Age from Attribute"

dictionary_conflict <- tibble::tribble(
  ~variable, ~description,
  "age", "Age from Dictionary"
)

# Attribute wins over dictionary
trial_both |>
  tbl_summary(by = trt, include = age) |>
  add_auto_labels(dictionary = dictionary_conflict) |>
  extras()

## ----eval=FALSE---------------------------------------------------------------
# options(sumExtras.auto_labels = TRUE)

## ----eval=FALSE---------------------------------------------------------------
# dictionary <- tibble::tribble(
#   ~variable,    ~description,
#   "age",        "Age at Enrollment (years)",
#   "marker",     "Marker Level (ng/mL)",
#   "grade",      "Tumor Grade"
# )
# 
# # No add_auto_labels() needed
# trial |>
#   tbl_summary(by = trt) |>
#   extras()

