/*
 * Decompiled with CFR 0.152.
 */
package partition;

import partition.Cell;
import partition.Cluster;
import partition.Location;

public abstract class CompactSpatialPartition {
    private int _numberOfIterations = 0;
    private int _maximumNumberOfIterations = 1000;
    protected Cell[] _cells;
    protected Cluster[] _clusters;

    public final int getNumberOfIterations() {
        return this._numberOfIterations;
    }

    public final int getMaximumNumberOfIterations() {
        return this._maximumNumberOfIterations;
    }

    public final void setMaximumNumberOfIterations(int maximumNumberOfIterations) {
        this._maximumNumberOfIterations = maximumNumberOfIterations;
    }

    public final int getNumberOfCells() {
        return this._cells.length;
    }

    public final int getNumberOfClusters() {
        return this._clusters.length;
    }

    public final int[] getClusterId() {
        int numberOfCells = this.getNumberOfCells();
        int[] clusterId = new int[numberOfCells];
        int i = 0;
        for (Cell cell : this._cells) {
            Cluster cluster = cell.getCluster();
            clusterId[i++] = cluster.getId();
        }
        return clusterId;
    }

    public final Location[] getCentroids() {
        int numberOfClusters = this.getNumberOfClusters();
        Location[] centroids = new Location[numberOfClusters];
        int i = 0;
        for (Cluster cluster : this._clusters) {
            centroids[i++] = cluster.getCenter();
        }
        return centroids;
    }

    abstract int runCycle();

    public final void optimize() {
        int i;
        for (i = 0; i < this._maximumNumberOfIterations; ++i) {
            int numberOfTransactions = this.runCycle();
            if (!this.hasConverged(numberOfTransactions)) continue;
            break;
        }
        this._numberOfIterations = i;
    }

    public final boolean hasConverged() {
        return this._numberOfIterations > 0 & this._numberOfIterations < this._maximumNumberOfIterations;
    }

    public final boolean hasConverged(int criterion) {
        return criterion == 0;
    }

    public final double getObjectiveFunctionValue() {
        double sum = 0.0;
        for (Cell cell : this._cells) {
            Cluster cluster = cell.getCluster();
            sum += cell.getSquaredDistanceTo(cluster);
        }
        int numberOfCells = this.getNumberOfCells();
        return sum / (double)numberOfCells;
    }
}

