/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13;

import java.util.function.IntToDoubleFunction;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.core.tests.CombinedSeasonality;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoublesMath;
import jdplus.toolkit.base.api.stats.AutoCovariances;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import jdplus.x13.base.api.x11.MsrTable;
import jdplus.x13.base.api.x11.SeasonalFilterOption;
import jdplus.x13.base.core.x11.X11Results;
import jdplus.x13.base.core.x11.X11Utility;
import jdplus.x13.base.core.x13.X13Finals;
import jdplus.x13.base.core.x13.X13Preadjustment;

public final class Mstatistics {
    private TsData O;
    private TsData P;
    private TsData TD;
    private TsData Ome;
    private TsData Oc;
    private TsData CIc;
    private TsData Cc;
    private TsData Sc;
    private TsData Ic;
    private TsData Omod;
    private TsData CImod;
    private TsData Imod;
    private TsData Snorm;
    private TsData Pt;
    private TsData Ps;
    private TsData Pi;
    private TsData SI;
    private TsData MCD;
    private TsData stO;
    private TsData stC;
    private double varC;
    private double varS;
    private double varI;
    private double varP;
    private double varTD;
    private Double icr;
    private double[] gP;
    private double[] gTD;
    private double[] gOmod;
    private double[] gCImod;
    private double[] gImod;
    private double[] gMCD;
    private boolean[] valid;
    private double[] gOc;
    private double[] gCc;
    private double[] gIc;
    private double[] gCIc;
    private double[] gSc;
    private final double[] m = new double[11];
    private boolean s3x5;
    private boolean bShort;
    private final DecompositionMode mode;
    private static final double[] wtFull = new double[]{10.0, 11.0, 10.0, 8.0, 11.0, 10.0, 18.0, 7.0, 7.0, 4.0, 4.0};
    private static final double[] wtShort = new double[]{14.0, 15.0, 10.0, 8.0, 11.0, 10.0, 32.0};
    private MsrTable rms;
    private double testvalue = 0.0;
    private double criticalvalue = 0.0;
    private boolean cochranTestResult = true;
    private int minNumberOfYears = 0;

    public static Mstatistics of(X13Preadjustment preadj, X11Results x11, X13Finals finals) {
        try {
            Mstatistics mstats = new Mstatistics(x11.getMode());
            TsData s = preadj.getA1();
            TsDomain dom = s.getDomain();
            mstats.O = s;
            mstats.Oc = TsData.fitToDomain((TsData)x11.getB1(), (TsDomain)dom);
            mstats.Cc = TsData.fitToDomain((TsData)x11.getD12(), (TsDomain)dom);
            mstats.CIc = TsData.fitToDomain((TsData)x11.getD11(), (TsDomain)dom);
            mstats.Sc = TsData.fitToDomain((TsData)x11.getD10(), (TsDomain)dom);
            mstats.Ic = TsData.fitToDomain((TsData)x11.getD13(), (TsDomain)dom);
            if (mstats.mode != DecompositionMode.PseudoAdditive) {
                mstats.TD = finals.getD18();
                mstats.P = preadj.getA8();
                mstats.Pt = preadj.getA8t();
                mstats.Ps = preadj.getA8s();
                mstats.Pi = preadj.getA8i();
            }
            mstats.SI = TsData.fitToDomain((TsData)x11.getD8(), (TsDomain)dom);
            mstats.Ome = finals.getE1();
            mstats.CImod = finals.getE2();
            mstats.Imod = finals.getE3();
            mstats.Omod = mstats.op(mstats.Ome, mstats.Pt);
            mstats.Omod = mstats.op(mstats.Omod, mstats.Ps);
            mstats.CImod = mstats.op(mstats.CImod, mstats.Pt);
            mstats.checkSeries();
            if (mstats.TD != null) {
                double m = mstats.TD.getValue(0);
                if (mstats.TD.getValues().allMatch(x -> m == x)) {
                    mstats.TD = null;
                }
            }
            mstats.rms = x11.getD9Msr();
            if (mstats.rms != null) {
                mstats.m[5] = 0.4 * Math.abs(mstats.rms.getGlobalMsr() - 4.0);
            }
            SeasonalFilterOption d9filter = x11.getD9filter();
            boolean sdef = x11.isD9default();
            mstats.s3x5 = !sdef && d9filter == SeasonalFilterOption.S3X5;
            mstats.icr = x11.getICRatio();
            if (mstats.icr != null) {
                mstats.m[2] = 0.5 * (mstats.icr - 1.0);
            }
            if (mstats.O.length() / mstats.O.getAnnualFrequency() < 6) {
                mstats.bShort = true;
            }
            mstats.calcStationaryVariances();
            mstats.calcSNorm();
            mstats.calcEvolutions();
            mstats.calcM();
            return mstats;
        }
        catch (RuntimeException err) {
            return null;
        }
    }

    public void checkSeries() {
        if (this.mode == DecompositionMode.PseudoAdditive) {
            this.valid = new boolean[this.Oc.length()];
            for (int i = 0; i < this.valid.length; ++i) {
                this.valid[i] = this.Oc.getValue(i) > 0.0 && this.CIc.getValue(i) > 0.0;
            }
        }
    }

    public int period() {
        return this.Oc.getAnnualFrequency();
    }

    public boolean[] validObservations() {
        return this.valid;
    }

    public TsData getO() {
        return this.O;
    }

    public TsData getP() {
        return this.P;
    }

    public TsData getOc() {
        return this.Oc;
    }

    public TsData getIc() {
        return this.Ic;
    }

    public TsData getCIc() {
        return this.CIc;
    }

    public TsData getCc() {
        return this.Cc;
    }

    public TsData getSc() {
        return this.Sc;
    }

    public TsData getMCD() {
        return this.MCD;
    }

    public TsData getstationaryC() {
        return this.stC;
    }

    public TsData getstationaryO() {
        return this.stO;
    }

    public double[] getOcChanges() {
        return this.gOc;
    }

    public double[] getOmodChanges() {
        return this.gOmod;
    }

    public double[] getIcChanges() {
        return this.gIc;
    }

    public double[] getImodChanges() {
        return this.gImod;
    }

    public double[] getCIcChanges() {
        return this.gCIc;
    }

    public double[] getCImodChanges() {
        return this.gCImod;
    }

    public double[] getCcChanges() {
        return this.gCc;
    }

    public double[] getScChanges() {
        return this.gSc;
    }

    public double[] getPChanges() {
        return this.gP;
    }

    public double[] getTDChanges() {
        return this.gTD;
    }

    public double[] getMCDChanges() {
        return this.gMCD;
    }

    public double getVarI() {
        return this.varI;
    }

    public double getVarS() {
        return this.varS;
    }

    public double getVarC() {
        return this.varC;
    }

    public double getVarP() {
        return this.varP;
    }

    public double getVarTD() {
        return this.varTD;
    }

    public double getCriticalValue() {
        return this.criticalvalue;
    }

    public double getTestValue() {
        return this.testvalue;
    }

    public boolean getCochranResult() {
        return this.cochranTestResult;
    }

    public int getminNumberOfYears() {
        return this.minNumberOfYears;
    }

    public double getAdrOfCI() {
        return X11Utility.adr(this.CIc.getValues(), this.mode.isMultiplicative());
    }

    public double getAdrOfI() {
        return X11Utility.adr(this.Ic.getValues(), this.mode.isMultiplicative());
    }

    public double getAdrOfC() {
        return X11Utility.adr(this.Cc.getValues(), this.mode.isMultiplicative());
    }

    public double[] getAutoCorrelationsOfIrregular() {
        DoubleSeq irr = this.Ic.getValues();
        if (this.mode.isMultiplicative()) {
            irr = irr.fastOp(a -> a - 1.0);
        }
        IntToDoubleFunction acf = AutoCovariances.autoCorrelationFunction((DoubleSeq)irr, (double)0.0);
        int ifreq = this.Ic.getAnnualFrequency();
        double[] c = new double[ifreq + 2];
        for (int i = 0; i < c.length; ++i) {
            c[i] = acf.applyAsDouble(i + 1);
        }
        return c;
    }

    private Mstatistics(DecompositionMode mode) {
        this.mode = mode;
        for (int i = 0; i < this.m.length; ++i) {
            this.m[i] = -1.0;
        }
    }

    private void calcEvolutions() {
        boolean mul = this.mode != DecompositionMode.Additive;
        int period = this.O.getAnnualFrequency();
        this.gOmod = X11Utility.calcAbsMeanVariations(this.Omod.getValues(), period, mul, this.valid);
        this.gCImod = X11Utility.calcAbsMeanVariations(this.CImod.getValues(), period, mul, this.valid);
        this.gImod = X11Utility.calcAbsMeanVariations(this.Imod.getValues(), period, mul, this.valid);
        this.gOc = X11Utility.calcAbsMeanVariations(this.Oc.getValues(), period, mul, this.valid);
        this.gCIc = X11Utility.calcAbsMeanVariations(this.CIc.getValues(), period, mul, this.valid);
        this.gCc = X11Utility.calcAbsMeanVariations(this.Cc.getValues(), period, mul, this.valid);
        this.gSc = X11Utility.calcAbsMeanVariations(this.Sc.getValues(), period, mul, this.valid);
        this.gIc = X11Utility.calcAbsMeanVariations(this.Ic.getValues(), period, mul, this.valid);
        if (this.P != null) {
            this.gP = X11Utility.calcAbsMeanVariations(this.P.getValues(), period, mul, this.valid);
        }
        if (this.TD != null) {
            this.gTD = X11Utility.calcAbsMeanVariations(this.TD.getValues(), period, mul, this.valid);
        }
    }

    private void calcM() {
        int del = 1;
        int p = this.O.getAnnualFrequency();
        if (p == 12) {
            del = 3;
        }
        this.calcM1(del);
        this.calcM2();
        this.calcM4();
        this.calcM5();
        this.calcM6();
        this.calcM7();
        this.calcM8();
        this.calcM9();
        this.calcM10();
        this.calcM11();
    }

    private void calcM1(int del) {
        boolean mul = this.mode != DecompositionMode.Additive;
        double mt = X11Utility.calcAbsMeanVariation(this.Cc.getValues(), del, mul, this.valid);
        mt *= mt;
        double mi = X11Utility.calcAbsMeanVariation(this.Imod.getValues(), del, mul, this.valid);
        mi *= mi;
        double ms = X11Utility.calcAbsMeanVariation(this.Sc.getValues(), del, mul, this.valid);
        ms *= ms;
        double mp = 0.0;
        if (this.P != null) {
            mp = X11Utility.calcAbsMeanVariation(this.P.getValues(), del, mul, this.valid);
            mp *= mp;
        }
        double mtd = 0.0;
        if (this.TD != null) {
            mtd = X11Utility.calcAbsMeanVariation(this.TD.getValues(), del, mul, this.valid);
            mtd *= mtd;
        }
        double mo = mt + mi + ms + mp + mtd;
        this.m[0] = 10.0 * (mi / mo) / (1.0 - mp / mo);
    }

    private void calcM10() {
        if (this.bShort) {
            return;
        }
        DoubleSeq s = this.Snorm.getValues();
        int period = this.Snorm.getAnnualFrequency();
        double ds = 0.0;
        int nn = period * 3;
        int n = s.length();
        for (int j = 1; j <= period; ++j) {
            int last = n - j - period;
            int first = last - 3 * period;
            if (first < period) {
                return;
            }
            for (int i = first; i < last; i += period) {
                ds += Math.abs(s.get(i) - s.get(i - period));
            }
        }
        this.m[9] = ds / (double)nn * 10.0;
    }

    private void calcM11() {
        if (this.bShort) {
            return;
        }
        DoubleSeq s = this.Snorm.getValues();
        int period = this.Snorm.getAnnualFrequency();
        double ds = 0.0;
        int nn = period * 3;
        int n = s.length();
        for (int j = 1; j <= period; ++j) {
            int last = n - j - 2 * period;
            int first = last - 3 * period;
            if (first < 0) {
                return;
            }
            ds += Math.abs(s.get(last) - s.get(first));
        }
        this.m[10] = ds / (double)nn * 10.0;
    }

    private void calcM2() {
        this.m[1] = this.varP >= 1.0 ? 3.0 : 10.0 * this.varI / (1.0 - this.varP);
    }

    private void calcM4() {
        double adr = X11Utility.adr(this.Ic.getValues(), this.mode != DecompositionMode.Additive);
        int n = this.Ic.length();
        double lv = Math.sqrt(1.6 * (double)n - 2.9) * 2.577;
        double uv = Math.abs((double)(3 * (n - 1)) / adr - (double)(2 * n - 1));
        this.m[3] = uv / lv;
    }

    private void calcM5() {
        double rmcd;
        int mcd;
        int ifreq = this.O.getAnnualFrequency();
        int c = 12 / ifreq;
        for (mcd = ifreq; mcd > 0 && this.smic(mcd) < 1.0; --mcd) {
        }
        if (mcd < ifreq) {
            ++mcd;
        }
        if (mcd == 1) {
            rmcd = 1.0 + (this.smic(1) - 1.0) / (this.smic(1) - this.smic(2));
            if (rmcd < 0.5) {
                rmcd = 0.5;
            }
            if (rmcd > 1.0) {
                rmcd = 1.0;
            }
        } else {
            double dsmic = this.smic(mcd - 1) - this.smic(mcd);
            rmcd = dsmic <= 0.0 && mcd == ifreq ? (double)c * 15.5 : (double)mcd + (this.smic(mcd) - 1.0) / dsmic;
        }
        this.m[4] = (rmcd * (double)c - 0.5) / 5.0;
    }

    private void calcM6() {
    }

    private void calcM7() {
        int period = this.O.getAnnualFrequency();
        int startPeriod = this.O.getStart().annualPosition();
        this.m[6] = (switch (this.mode) {
            case DecompositionMode.LogAdditive -> new CombinedSeasonality(this.SI.getValues().log(), period, startPeriod, 0.0);
            case DecompositionMode.Additive -> new CombinedSeasonality(this.SI.getValues(), period, startPeriod, 0.0);
            default -> new CombinedSeasonality(this.SI.getValues(), period, startPeriod, 1.0);
        }).mvalue();
    }

    private void calcM8() {
        if (this.bShort) {
            return;
        }
        int ifreq = this.O.getAnnualFrequency();
        TsData s = this.Snorm.delta(ifreq);
        this.m[7] = 10.0 * s.getValues().fastOp(z -> Math.abs(z)).average();
    }

    private void calcM9() {
        if (this.bShort) {
            return;
        }
        DoubleSeq s = this.Snorm.getValues();
        int period = this.Snorm.getAnnualFrequency();
        double ds = 0.0;
        int n = s.length();
        for (int j = 1; j <= period; ++j) {
            int last = n - j;
            int first = last % period;
            int m = (last - first) / period;
            ds += Math.abs(s.get(last) - s.get(first)) / (double)m;
        }
        this.m[8] = ds / (double)period * 10.0;
    }

    private void calcSNorm() {
        double stde = 0.0;
        stde = this.mode != DecompositionMode.Additive ? Math.sqrt(this.Sc.getValues().fastOp(z -> z - 1.0).ssq() / (double)this.Sc.length()) : Math.sqrt(this.Sc.getValues().ssq() / (double)this.Sc.length());
        this.Snorm = TsData.of((TsPeriod)this.Sc.getStart(), (DoubleSeq)this.Sc.getValues().times(1.0 / stde));
    }

    private double variance(TsData s, boolean log, boolean zero) {
        double x;
        int i;
        if (log) {
            s = s.log();
        }
        int n = s.length();
        int m = 0;
        double z = 0.0;
        double mu = 0.0;
        if (!zero) {
            for (i = 0; i < n; ++i) {
                x = s.getValue(i);
                if (this.valid != null && !this.valid[i] || !Double.isFinite(x)) continue;
                ++m;
                z += x;
            }
            mu = z / (double)m;
        }
        z = 0.0;
        for (i = 0; i < n; ++i) {
            x = s.getValue(i);
            if (this.valid != null && !this.valid[i] || !Double.isFinite(x)) continue;
            z += (x -= mu) * x;
        }
        return z;
    }

    private void calcStationaryVariances() {
        DoubleSeq sto;
        DoubleSeq stc;
        int n = this.Cc.length();
        if (this.mode != DecompositionMode.Additive) {
            lm = LinearModel.builder().y(this.Cc.getValues().log()).meanCorrection(true).addX(DoubleSeq.onMapping((int)n, i -> i)).build();
            LeastSquaresResults lsr = Ols.compute((LinearModel)lm);
            DoubleSeq lt = lsr.regressionEffect();
            stc = DoublesMath.subtract((DoubleSeq)lm.getY(), (DoubleSeq)lt);
            sto = this.Ome.getValues().fn(lt, (a, b) -> Math.log(a) - b);
        } else {
            lm = LinearModel.builder().y(this.Cc.getValues()).meanCorrection(true).addX(DoubleSeq.onMapping((int)n, i -> i)).build();
            LeastSquaresResults lsr = Ols.compute((LinearModel)lm);
            DoubleSeq lt = lsr.regressionEffect();
            stc = DoublesMath.subtract((DoubleSeq)lm.getY(), (DoubleSeq)lt);
            sto = DoublesMath.subtract((DoubleSeq)this.Ome.getValues(), (DoubleSeq)lt);
        }
        this.stC = TsData.of((TsPeriod)this.Cc.getStart(), (DoubleSeq)stc);
        this.stO = TsData.of((TsPeriod)this.Ome.getStart(), (DoubleSeq)sto);
        double varO = this.variance(this.stO, false, false);
        this.varC = this.variance(this.stC, false, false);
        this.varS = this.variance(this.Sc, this.mode != DecompositionMode.Additive, true);
        this.varI = this.variance(this.Imod, this.mode != DecompositionMode.Additive, true);
        if (this.P != null) {
            this.varP = this.variance(this.P, this.mode != DecompositionMode.Additive, false);
        }
        if (this.TD != null) {
            this.varTD = this.variance(this.TD, this.mode != DecompositionMode.Additive, true);
        }
        this.varP /= varO;
        this.varTD /= varO;
        this.varS /= varO;
        this.varC /= varO;
        this.varI /= varO;
    }

    public DecompositionMode getMode() {
        return this.mode;
    }

    public double getM(int q) {
        double x = this.m[q - 1];
        if (x > 3.0) {
            return 3.0;
        }
        if (x < 0.0) {
            return 0.0;
        }
        return x;
    }

    public int getMCount() {
        return this.m.length;
    }

    public double getQ() {
        double q = 0.0;
        double wtot = 0.0;
        double[] wt = this.bShort ? wtShort : wtFull;
        for (int i = 0; i < wt.length; ++i) {
            if (this.m[i] == -1.0 || i == 5 && !this.s3x5) continue;
            wtot += wt[i];
            if (this.m[i] > 3.0) {
                q += 3.0 * wt[i];
                continue;
            }
            if (!(this.m[i] > 0.0)) continue;
            q += this.m[i] * wt[i];
        }
        return q / wtot;
    }

    public double getQm2() {
        double q = 0.0;
        double wtot = 0.0;
        double[] wt = this.bShort ? wtShort : wtFull;
        for (int i = 0; i < wt.length; ++i) {
            if (i == 1 || this.m[i] == -1.0 || i == 5 && !this.s3x5) continue;
            wtot += wt[i];
            if (this.m[i] > 3.0) {
                q += 3.0 * wt[i];
                continue;
            }
            if (!(this.m[i] > 0.0)) continue;
            q += this.m[i] * wt[i];
        }
        return q / wtot;
    }

    public Double getIcr() {
        return this.icr;
    }

    public MsrTable getRms() {
        return this.rms;
    }

    public double getVarTotal() {
        return this.varC + this.varS + this.varI + this.varP + this.varTD;
    }

    public boolean isUsedM(int q) {
        return this.m[q - 1] != -1.0;
    }

    private TsData op(TsData l, TsData r) {
        if (this.mode != DecompositionMode.Additive) {
            return TsData.divide((TsData)l, (TsData)r);
        }
        return TsData.subtract((TsData)l, (TsData)r);
    }

    private double smic(int m) {
        int i = m - 1;
        return this.gIc[i] / this.gCc[i];
    }
}

