/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.math.functions.levmar.LevenbergMarquardtMinimizer;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.regsarima.regular.IModelEstimator;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.tramoseats.base.core.tramo.internal.OutliersDetectionModule;

class ModelEstimator
implements IModelEstimator {
    private final OutliersDetectionModule outliers;
    private final double eps;
    private final double va;

    ModelEstimator(double eps, double va, OutliersDetectionModule outliers) {
        this.eps = eps;
        this.va = va;
        this.outliers = outliers;
    }

    public boolean estimate(RegSarimaModelling context) {
        context.getDescription().removeVariable(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true));
        if (this.outliers != null) {
            this.outliers.process(context, this.va);
        }
        return this.calc(context);
    }

    private boolean calc(RegSarimaModelling context) {
        RegSarimaComputer processor = RegSarimaComputer.builder().minimizer((SsqFunctionMinimizer.Builder)LevenbergMarquardtMinimizer.builder()).precision(this.eps).build();
        context.estimate((IRegArimaComputer)processor);
        return true;
    }
}

