/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import jdplus.toolkit.base.api.data.ParameterType;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import lombok.Generated;

public final class Buffers {
    public static int outlier(String type) {
        switch (type) {
            case "AO": 
            case "ao": {
                return 1;
            }
            case "LS": 
            case "ls": {
                return 2;
            }
            case "TC": 
            case "tc": {
                return 3;
            }
            case "SO": 
            case "so": {
                return 4;
            }
        }
        return 0;
    }

    public static String outlier(int type) {
        switch (type) {
            case 1: {
                return "AO";
            }
            case 2: {
                return "LS";
            }
            case 3: {
                return "TC";
            }
            case 4: {
                return "SO";
            }
        }
        return null;
    }

    public static TimeSelector selector(double[] buffer, int pos) {
        int stype = (int)buffer[pos++];
        switch (stype) {
            case 1: {
                return TimeSelector.all();
            }
            case 2: {
                return TimeSelector.from((LocalDateTime)Buffers.dateTime(buffer, pos));
            }
            case 3: {
                return TimeSelector.to((LocalDateTime)Buffers.dateTime(buffer, pos + 3));
            }
            case 4: {
                return TimeSelector.between((LocalDateTime)Buffers.dateTime(buffer, pos), (LocalDateTime)Buffers.dateTime(buffer, pos + 3));
            }
            case 5: {
                return TimeSelector.last((int)((int)buffer[pos + 3]));
            }
            case 6: {
                return TimeSelector.first((int)((int)buffer[pos]));
            }
            case 7: {
                return TimeSelector.excluding((int)((int)buffer[pos]), (int)((int)buffer[pos + 3]));
            }
        }
        return TimeSelector.none();
    }

    public static void selector(double[] input, int pos, TimeSelector span) {
        switch (span.getType()) {
            case All: {
                input[pos++] = 1.0;
                break;
            }
            case From: {
                input[pos++] = 2.0;
                Buffers.date(input, pos, span.getD0());
                break;
            }
            case To: {
                input[pos++] = 3.0;
                Buffers.date(input, pos + 3, span.getD1());
                break;
            }
            case Between: {
                input[pos++] = 4.0;
                Buffers.date(input, pos, span.getD0());
                Buffers.date(input, pos + 3, span.getD1());
                break;
            }
            case Last: {
                input[pos++] = 5.0;
                input[pos + 3] = span.getN1();
                break;
            }
            case First: {
                input[pos++] = 6.0;
                input[pos] = span.getN0();
                break;
            }
            case Excluding: {
                input[pos++] = 7.0;
                input[pos] = span.getN0();
                input[pos + 3] = span.getN1();
            }
        }
    }

    public static TimeSelector.SelectionType selectorType(int type) {
        switch (type) {
            case 1: {
                return TimeSelector.SelectionType.All;
            }
            case 2: {
                return TimeSelector.SelectionType.From;
            }
            case 3: {
                return TimeSelector.SelectionType.To;
            }
            case 4: {
                return TimeSelector.SelectionType.Between;
            }
            case 5: {
                return TimeSelector.SelectionType.Last;
            }
            case 6: {
                return TimeSelector.SelectionType.First;
            }
            case 7: {
                return TimeSelector.SelectionType.Excluding;
            }
        }
        return TimeSelector.SelectionType.None;
    }

    public static LocalDate date(double[] buffer, int pos) {
        return LocalDate.of((int)buffer[pos], (int)buffer[pos + 1], (int)buffer[pos + 2]);
    }

    public static void date(double[] buffer, int pos, LocalDate date) {
        buffer[pos] = date.getYear();
        buffer[pos + 1] = date.getMonthValue();
        buffer[pos + 2] = date.getDayOfMonth();
    }

    public static LocalDateTime dateTime(double[] buffer, int pos) {
        return Buffers.date(buffer, pos).atStartOfDay();
    }

    public static void date(double[] buffer, int pos, LocalDateTime date) {
        Buffers.date(buffer, pos, date.toLocalDate());
    }

    public static int parameterType(ParameterType type) {
        switch (type) {
            case Undefined: {
                return 1;
            }
            case Initial: {
                return 2;
            }
            case Fixed: {
                return 3;
            }
            case Estimated: {
                return 4;
            }
        }
        return 0;
    }

    public static ParameterType parameterType(int type) {
        switch (type) {
            case 1: {
                return ParameterType.Undefined;
            }
            case 2: {
                return ParameterType.Initial;
            }
            case 3: {
                return ParameterType.Fixed;
            }
            case 4: {
                return ParameterType.Estimated;
            }
        }
        return null;
    }

    @Generated
    private Buffers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

