## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval = FALSE-------------------------------------------------------------
# set.seed(2026)
# n <- nrow(newborn)
# idx <- sample(1:n, size = round(0.7 * n), replace = FALSE)
# train_data <- newborn[idx, ]
# test_data <- newborn[-idx, ]

## ----eval = FALSE-------------------------------------------------------------
# # create a temporary folder
# tmp_folder <- file.path(tempdir(), "mixgb_models")
# dir.create(tmp_folder, showWarnings = FALSE)
# 
# # obtain m imputed datasets for train_data and save imputation models
# mixgb_obj <- mixgb(
#   data = train_data, m = 5,
#   save.models = TRUE, save.models.folder = tmp_folder
# )
# 
# saveRDS(
#   object = mixgb_obj,
#   file = file.path(tmp_folder, "mixgb_imputer.rds")
# )

## ----eval=FALSE---------------------------------------------------------------
# mixgb_obj <- readRDS(file = file.path(tmp_folder, "mixgb_imputer.rds"))
# test_imp <- impute_new(object = mixgb_obj, newdata = test_data)

## ----eval = FALSE-------------------------------------------------------------
# test_imp <- impute_new(object = mixgb_obj, newdata = test_data)

## ----eval = FALSE-------------------------------------------------------------
# test_imp <- impute_new(
#   object = mixgb_obj, newdata = test_data,
#   initial.newdata = FALSE, pmm.k = 3, m = 4
# )

