/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import lombok.Generated;

public final class SymmetricFiltersFactory {
    public static SymmetricFilter makeSymmetricFilter(int m, int n) {
        if ((m + n) % 2 == 1) {
            throw new IllegalArgumentException();
        }
        Polynomial M = SymmetricFiltersFactory.simpleFilter(m);
        Polynomial N = SymmetricFiltersFactory.simpleFilter(n);
        return SymmetricFilter.of(M.times(N).coefficients());
    }

    private static Polynomial simpleFilter(int len) {
        double[] c = new double[len];
        double w = 1.0 / (double)len;
        for (int i = 0; i < len; ++i) {
            c[i] = w;
        }
        return Polynomial.of(c);
    }

    public static SymmetricFilter makeSymmetricFilter(int length) {
        int ilen = (length + 1) / 2;
        if (length % 2 == 1) {
            double[] c = new double[ilen];
            double w = 1.0 / (double)length;
            for (int i = 0; i < c.length; ++i) {
                c[i] = w;
            }
            return SymmetricFilter.ofInternal(c);
        }
        double[] c = new double[ilen + 1];
        double w = 1.0 / (double)length;
        for (int i = 0; i < ilen; ++i) {
            c[i] = w;
        }
        c[ilen] = w / 2.0;
        return SymmetricFilter.ofInternal(c);
    }

    @Generated
    private SymmetricFiltersFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

