/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.calendars;

import java.time.LocalDate;
import lombok.Generated;

public final class Easter {
    public static final double LUNARY = 29.53059;
    public static final double DEC_LUNARY = 0.53059;
    static int CYCLE = 532;
    static int TWOCYCLE = CYCLE << 1;
    static int[] PROB = new int[]{4, 8, 8, 12, 16, 16, 20, 16, 16, 20, 16, 16, 20, 16, 20, 20, 16, 20, 16, 16, 20, 16, 16, 20, 16, 20, 16, 16, 20, 16, 12, 12, 8, 8, 4};
    private static final int[] JD = new int[]{1, 1, 3, 9, 15, 11, 14, 27, 36, 28, 24, 32, 40, 39, 33, 31, 34, 36, 42, 39, 33, 31, 33, 42, 38, 33, 30, 32, 39, 40, 33, 29, 26, 31, 33, 22, 7, 15, 12, 7, 1, 1, 1};

    public static LocalDate easter(int y) {
        int a = y % 19;
        int b = y / 100;
        int c = y % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * l) / 451;
        int month = (h + l - 7 * m + 114) / 31;
        int day = (h + l - 7 * m + 114) % 31 + 1;
        return LocalDate.of(y, month, day);
    }

    public static LocalDate easter2(int y) {
        int td;
        int te;
        int d;
        int firstdig = y / 100;
        int remain19 = y % 19;
        int temp = (firstdig - 15) / 2 + 202 - 11 * remain19;
        if (firstdig == 21 || firstdig == 24 || firstdig == 25 || firstdig >= 27 && firstdig <= 32 || firstdig == 34 || firstdig == 35 || firstdig == 38) {
            --temp;
        } else if (firstdig == 33 || firstdig == 36 || firstdig == 37 || firstdig == 39 || firstdig == 40) {
            temp -= 2;
        }
        int ta = (temp %= 30) + 21;
        if (temp == 29) {
            --ta;
        }
        if (temp == 28 && remain19 > 10) {
            --ta;
        }
        int tb = (ta - 19) % 7;
        int tc = (40 - firstdig) % 4;
        if (tc == 3) {
            ++tc;
        }
        if (tc > 1) {
            ++tc;
        }
        if ((d = ta + (te = (20 - tb - tc - (td = ((temp = y % 100) + temp / 4) % 7)) % 7 + 1)) > 31) {
            return LocalDate.of(y, 4, d - 31);
        }
        return LocalDate.of(y, 3, d);
    }

    public static int julianDate2JDN(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        return day + (153 * m + 2) / 5 + 365 * y + y / 4 - 32083;
    }

    public static int gregorianDate2JDN(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        return day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
    }

    public static LocalDate JDN2GregorianDate(int jdn) {
        int y = 4716;
        int v = 3;
        int j = 1401;
        int u = 5;
        int m = 2;
        int s = 153;
        int n = 12;
        int w = 2;
        int r = 4;
        int B = 274277;
        int p = 1461;
        int C = -38;
        int f = jdn + 1401 + (4 * jdn + 274277) / 146097 * 3 / 4 + -38;
        int e = 4 * f + 3;
        int g = e % 1461 / 4;
        int h = 5 * g + 2;
        int D = h % 153 / 5;
        int M = (h / 153 + 2) % 12;
        int Y = e / 1461 - 4716 + (14 - M) / 12;
        return LocalDate.of(Y, M + 1, D + 1);
    }

    public static LocalDate julianEaster(int year, boolean gregorian) {
        int a = year % 19;
        int b = year % 4;
        int c = year % 7;
        int d = (19 * a + 15) % 30;
        int e = (2 * b + 4 * c - d + 34) % 7;
        int f = d + e + 114;
        int month = f / 31;
        int day = f % 31 + 1;
        if (gregorian) {
            return Easter.JDN2GregorianDate(Easter.julianDate2JDN(year, month, day));
        }
        return LocalDate.of(year, month, day);
    }

    public static double probJulianEaster(int pos) {
        if (pos < 0 || pos >= 43) {
            return 0.0;
        }
        double denom = TWOCYCLE;
        return (double)JD[pos] / denom;
    }

    public static double probEaster(int pos) {
        if (pos < 0 || pos >= 35) {
            return 0.0;
        }
        if (pos < 6) {
            return (double)(pos + 1) / 206.71413;
        }
        if (pos < 28) {
            return 0.03386319067786996;
        }
        return ((double)(35 - pos) + 0.53059) / 206.71413;
    }

    @Generated
    private Easter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

