## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(envsetup)

# Create temporary directory
dir <- fs::file_temp()
dir.create(dir)
config_path <- file.path(dir, "_envsetup.yml")

# Write multi-environment config
file_conn <- file(config_path)
writeLines(
  paste0(
"default:
  paths:
    data: '", dir, "/demo/DEV/username/project1/data'
    output: '", dir, "/demo/DEV/username/project1/output'
    programs: '", dir, "/demo/DEV/username/project1/programs'

qa:
  paths:
    data: '", dir, "/demo/QA/project1/data'
    output: '", dir, "/demo/QA/project1/output'
    programs: '", dir, "/demo/QA/project1/programs'

prod:
  paths:
    data: '", dir, "/demo/PROD/project1/data'
    output: '", dir, "/demo/PROD/project1/output'
    programs: '", dir, "/demo/PROD/project1/programs'"
  ), file_conn)
close(file_conn)

## -----------------------------------------------------------------------------
# Load default configuration (development)
envsetup_config <- config::get(file = config_path)
rprofile(envsetup_config)

# Check the paths
cat("Default environment paths:\n")
cat("Data:", get_path(data), "\n")
cat("Output:", get_path(output), "\n")

## -----------------------------------------------------------------------------
# Load QA configuration
envsetup_config <- config::get(file = config_path, config = "qa")
rprofile(envsetup_config)

# Check the paths
cat("QA environment paths:\n")
cat("Data:", get_path(data), "\n")
cat("Output:", get_path(output), "\n")

## -----------------------------------------------------------------------------
# Load production configuration
envsetup_config <- config::get(file = config_path, config = "prod")
rprofile(envsetup_config)

# Check the paths
cat("Production environment paths:\n")
cat("Data:", get_path(data), "\n")
cat("Output:", get_path(output), "\n")

## ----echo = FALSE-------------------------------------------------------------
# Clean up
unlink(dir, recursive=TRUE)

