/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import jdplus.toolkit.base.api.timeseries.TimeSeriesObs;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.util.HasShortStringRepresentation;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TsObs
implements TimeSeriesObs<TsPeriod>,
HasShortStringRepresentation {
    @NonNull
    private final TsPeriod period;
    private final double value;

    @NonNull
    public static TsObs parse(@NonNull CharSequence text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        int index = text.toString().indexOf("=");
        if (index < 0) {
            throw new IllegalArgumentException("Invalid TsObs text: " + String.valueOf(text));
        }
        return TsObs.of(TsPeriod.parse(text.subSequence(0, index)), Double.parseDouble(text.subSequence(index + 1, text.length()).toString()));
    }

    public String toString() {
        return String.valueOf(this.period) + "=" + this.value;
    }

    @Override
    @NonNull
    public String toShortString() {
        return this.period.toShortString() + "=" + this.value;
    }

    @Generated
    private TsObs(@NonNull TsPeriod period, double value) {
        if (period == null) {
            throw new NullPointerException("period is marked non-null but is null");
        }
        this.period = period;
        this.value = value;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull TsObs of(@NonNull TsPeriod period, double value) {
        if (period == null) {
            throw new NullPointerException("period is marked non-null but is null");
        }
        return new TsObs(period, value);
    }

    @Override
    @NonNull
    @Generated
    public TsPeriod getPeriod() {
        return this.period;
    }

    @Override
    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsObs)) {
            return false;
        }
        TsObs other = (TsObs)o;
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        TsPeriod this$period = this.getPeriod();
        TsPeriod other$period = other.getPeriod();
        return !(this$period == null ? other$period != null : !((Object)this$period).equals(other$period));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        TsPeriod $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        return result;
    }
}

