/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.regarima.diagnostics.OutliersDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regarima.diagnostics.OutliersDiagnosticsFactory;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;

public final class OutliersDiagnostics
implements Diagnostics {
    private final OutliersDiagnosticsConfiguration config;
    private int n;
    private int prespecifiedOutliers;
    private int detectedOutliers;

    static OutliersDiagnostics create(RegSarimaModel model, OutliersDiagnosticsConfiguration config) {
        try {
            if (model == null) {
                return null;
            }
            return new OutliersDiagnostics(model, config);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private OutliersDiagnostics(RegSarimaModel model, OutliersDiagnosticsConfiguration config) {
        this.config = config;
        this.test(model);
    }

    private void test(RegSarimaModel rslts) {
        GeneralLinearModel.Estimation estimation = rslts.getEstimation();
        if (estimation == null) {
            return;
        }
        this.n = estimation.getY().length() - estimation.getMissing().length;
        this.prespecifiedOutliers = (int)Arrays.stream(rslts.getDescription().getVariables()).filter(var -> ModellingUtility.isOutlier((Variable)var)).filter(var -> !ModellingUtility.isAutomaticallyIdentified((Variable)var)).count();
        this.detectedOutliers = (int)Arrays.stream(rslts.getDescription().getVariables()).filter(var -> ModellingUtility.isOutlier((Variable)var)).filter(var -> ModellingUtility.isAutomaticallyIdentified((Variable)var)).count();
    }

    public String getName() {
        return "Outliers";
    }

    public List<String> getTests() {
        return OutliersDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        double r = this.getValue(test);
        if (Double.isNaN(r)) {
            return ProcQuality.Undefined;
        }
        if (r > this.config.getSevereThreshold()) {
            return ProcQuality.Severe;
        }
        if (r > this.config.getBadThreshold()) {
            return ProcQuality.Bad;
        }
        if (r > this.config.getUncertainThreshold()) {
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Good;
    }

    public double getValue(String test) {
        if (!test.equals("number of outliers")) {
            return Double.NaN;
        }
        if (this.n == 0) {
            return Double.NaN;
        }
        double dn = this.n;
        return (double)(this.prespecifiedOutliers + this.detectedOutliers) / dn;
    }

    public List<String> getWarnings() {
        return Collections.emptyList();
    }
}

