/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima;

import internal.toolkit.base.core.arima.AutoCovarianceComputers;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public final class AutoCovarianceFunction {
    private static final AtomicReference<Computer> DEF_COMPUTER = new AtomicReference<Computer>(AutoCovarianceComputers.defaultComputer(null));
    private static final AtomicReference<SymmetricComputer> DEF_SYMCOMPUTER = new AtomicReference<SymmetricComputer>(AutoCovarianceComputers.defaultSymmetricComputer(null));
    private static final int BLOCK = 36;
    private final Polynomial ar;
    private final Polynomial ma;
    private final SymmetricFilter sma;
    private volatile double[] ac;
    private final double ivar;

    public static void setDefautComputer(Computer computer) {
        DEF_COMPUTER.set(computer);
    }

    public AutoCovarianceFunction(Polynomial ma, Polynomial ar, double var) {
        this.ma = ma;
        this.ar = ar;
        if (ar.degree() == 0) {
            this.sma = SymmetricFilter.convolutionOf(new BackFilter(ma), var);
            this.ivar = 1.0;
        } else {
            this.sma = null;
            this.ivar = var;
        }
    }

    public AutoCovarianceFunction(SymmetricFilter sma, Polynomial ar) {
        this.sma = sma;
        this.ar = ar;
        this.ma = null;
        this.ivar = 1.0;
    }

    public double[] values(int n) {
        this.prepare(n);
        double[] a = new double[n];
        int nmax = Math.min(n, this.ac.length);
        System.arraycopy(this.ac, 0, a, 0, nmax);
        return a;
    }

    public double get(int k) {
        this.prepare(k + 1);
        if (k >= this.ac.length) {
            return 0.0;
        }
        return this.ac[k];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(int rank) {
        if (rank == 0) {
            rank = 36;
        } else {
            int r = rank % 36;
            if (r != 0) {
                rank += 36 - r;
            }
        }
        double[] acov = this.ac;
        if (acov == null || acov.length <= rank) {
            AutoCovarianceFunction autoCovarianceFunction = this;
            synchronized (autoCovarianceFunction) {
                acov = this.ac;
                if (acov == null || acov.length <= rank) {
                    this.ac = this.ac(acov, rank);
                }
            }
        }
    }

    private double[] ac(double[] acov, int rank) {
        if (acov == null) {
            if (this.sma == null) {
                acov = DEF_COMPUTER.get().ac(this.ma, this.ar, rank);
                if (this.ivar != 1.0) {
                    int i = 0;
                    while (i < acov.length) {
                        int n = i++;
                        acov[n] = acov[n] * this.ivar;
                    }
                }
            } else {
                acov = DEF_SYMCOMPUTER.get().ac(this.sma, this.ar, rank);
            }
        }
        if (acov.length <= rank) {
            double[] tmp = new double[rank + 1];
            System.arraycopy(acov, 0, tmp, 0, acov.length);
            int p = this.ar.degree();
            for (int r = acov.length; r <= rank; ++r) {
                double s = 0.0;
                for (int j = 1; j <= p; ++j) {
                    s += this.ar.get(j) * tmp[r - j];
                }
                tmp[r] = -s;
            }
            acov = tmp;
        }
        return acov;
    }

    public int getBound() {
        if (!this.hasBound()) {
            return -1;
        }
        return this.ma.degree() + 1;
    }

    public boolean hasBound() {
        return this.ar.degree() + 1 == 1;
    }

    public IntToDoubleFunction asFunction() {
        return i -> this.get(i);
    }

    @FunctionalInterface
    public static interface Computer {
        public double[] ac(Polynomial var1, Polynomial var2, int var3);
    }

    @FunctionalInterface
    public static interface SymmetricComputer {
        public double[] ac(SymmetricFilter var1, Polynomial var2, int var3);
    }
}

