/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.jsoup.nodes;

import standalone_spreadsheet.org.jsoup.helper.Validate;
import standalone_spreadsheet.org.jsoup.internal.QuietAppendable;
import standalone_spreadsheet.org.jsoup.internal.StringUtil;
import standalone_spreadsheet.org.jsoup.nodes.Document;
import standalone_spreadsheet.org.jsoup.nodes.Entities;
import standalone_spreadsheet.org.jsoup.nodes.LeafNode;

public class TextNode
extends LeafNode {
    public TextNode(String text) {
        super(text);
    }

    @Override
    public String nodeName() {
        return "#text";
    }

    public String text() {
        return StringUtil.normaliseWhitespace(this.getWholeText());
    }

    public TextNode text(String text) {
        this.coreValue(text);
        return this;
    }

    public String getWholeText() {
        return this.coreValue();
    }

    public boolean isBlank() {
        return StringUtil.isBlank(this.coreValue());
    }

    public TextNode splitText(int offset) {
        String text = this.coreValue();
        Validate.isTrue(offset >= 0, "Split offset must be not be negative");
        Validate.isTrue(offset < text.length(), "Split offset must not be greater than current text length");
        String head = text.substring(0, offset);
        String tail = text.substring(offset);
        this.text(head);
        TextNode tailNode = new TextNode(tail);
        if (this.parentNode != null) {
            this.parentNode.addChildren(this.siblingIndex() + 1, tailNode);
        }
        return tailNode;
    }

    @Override
    void outerHtmlHead(QuietAppendable accum, Document.OutputSettings out) {
        Entities.escape(accum, this.coreValue(), out, 1);
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public TextNode clone() {
        return (TextNode)super.clone();
    }

    public static TextNode createFromEncoded(String encodedText) {
        String text = Entities.unescape(encodedText);
        return new TextNode(text);
    }

    static String normaliseWhitespace(String text) {
        text = StringUtil.normaliseWhitespace(text);
        return text;
    }

    static String stripLeadingWhitespace(String text) {
        return text.replaceFirst("^\\s+", "");
    }

    static boolean lastCharIsWhitespace(StringBuilder sb) {
        return sb.length() != 0 && sb.charAt(sb.length() - 1) == ' ';
    }
}

