/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.information;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.xml.information.XmlMetaData;
import jdplus.toolkit.base.xml.information.XmlTsData;
import jdplus.toolkit.base.xml.information.XmlTsUnit;
import jdplus.toolkit.base.xml.legacy.IXmlConverter;

@XmlRootElement(name="ts")
@XmlType(name="tsType")
public class XmlTs
implements IXmlConverter<Ts> {
    static final String NAME = "tsType";
    static final String RNAME = "ts";
    @XmlElement
    public Integer freq;
    @XmlElement
    public Integer firstYear;
    @XmlElement
    public Integer firstPeriod;
    @XmlElement
    public XmlTsUnit unit;
    @XmlElement
    public String start;
    @XmlElement(name="data")
    @XmlList
    public double[] data;
    @XmlElement
    public XmlMetaData metaData;
    @XmlAttribute
    public String name;
    @XmlAttribute
    public String source;
    @XmlAttribute
    public String identifier;

    @Override
    public void copy(Ts t) {
        TsData tsdata = t.getData();
        TsPeriod tstart = tsdata.getStart();
        int ifreq = tstart.getUnit().getAnnualFrequency();
        if (ifreq > 0) {
            this.freq = ifreq;
            this.firstYear = tstart.year();
            this.firstPeriod = tstart.annualPosition() + 1;
        } else {
            this.unit = new XmlTsUnit();
            this.unit.copy(tstart.getUnit());
            this.start = tstart.start().format(DateTimeFormatter.ISO_DATE_TIME);
        }
        this.data = tsdata.getValues().toArray();
        this.source = t.getMoniker().getSource();
        this.identifier = t.getMoniker().getId();
        this.name = t.getName();
        Map meta = t.getMeta();
        if (meta != null && !meta.isEmpty()) {
            this.metaData = new XmlMetaData();
            this.metaData.copy(meta);
        }
    }

    @Override
    public Ts create() {
        TsMoniker moniker = this.source == null && this.identifier == null ? TsMoniker.of() : TsMoniker.of((String)this.source, (String)this.identifier);
        Ts.Builder info = Ts.builder().name(this.name).moniker(moniker).type(this.data != null ? TsInformationType.UserDefined : TsInformationType.None);
        if (this.metaData != null) {
            info.meta((Map)this.metaData.create());
        }
        if (this.data != null) {
            if (this.freq != null) {
                info.data(XmlTsData.of(this.freq, this.firstYear, this.firstPeriod, this.data));
            } else {
                LocalDateTime tstart = LocalDateTime.parse(this.start, DateTimeFormatter.ISO_DATE_TIME);
                TsPeriod pstart = TsPeriod.of((TsUnit)this.unit.create(), (LocalDateTime)tstart);
                info.data(TsData.ofInternal((TsPeriod)pstart, (double[])(this.data == null ? Doubles.EMPTYARRAY : this.data)));
            }
        }
        return info.build();
    }
}

