/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramoseats;

import java.util.ArrayList;
import jdplus.sa.base.api.HasSaEstimation;
import jdplus.sa.base.api.SaEstimation;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.processing.DefaultProcessingLog;
import jdplus.toolkit.base.api.processing.ProcDiagnostic;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.processing.ProcSpecification;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.processing.ProcessingStatus;
import jdplus.toolkit.base.api.timeseries.AbstractTsDocument;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.tramoseats.base.api.tramoseats.TramoSeatsSpec;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsFactory;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsKernel;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsResults;

public class TramoSeatsDocument
extends AbstractTsDocument<TramoSeatsSpec, TramoSeatsResults>
implements HasSaEstimation {
    private final ModellingContext context;

    public TramoSeatsDocument() {
        super((ProcSpecification)TramoSeatsSpec.RSAfull);
        this.context = ModellingContext.getActiveContext();
    }

    public TramoSeatsDocument(ModellingContext context) {
        super((ProcSpecification)TramoSeatsSpec.RSAfull);
        this.context = context;
    }

    public ModellingContext getContext() {
        return this.context;
    }

    protected TramoSeatsResults internalProcess(TramoSeatsSpec spec, TsData data) {
        return TramoSeatsKernel.of(spec, this.context).process(data, (ProcessingLog)new DefaultProcessingLog());
    }

    public SaEstimation getEstimation() {
        if (this.getStatus() == ProcessingStatus.Unprocessed) {
            return null;
        }
        ArrayList tests = new ArrayList();
        TramoSeatsResults result = (TramoSeatsResults)this.getResult();
        TramoSeatsSpec pspec = null;
        ProcQuality quality = ProcQuality.Error;
        ArrayList warnings = new ArrayList();
        if (this.getStatus() == ProcessingStatus.Valid) {
            TramoSeatsFactory.getInstance().fillDiagnostics(tests, warnings, (Explorable)result);
            pspec = TramoSeatsFactory.getInstance().generateSpec((TramoSeatsSpec)this.getSpecification(), result);
            quality = ProcDiagnostic.summary(tests);
        }
        return SaEstimation.builder().results((GenericExplorable)result).diagnostics(tests).quality(quality).pointSpec(pspec).warnings(warnings).build();
    }
}

