/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo.internal;

import java.util.Arrays;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarmaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.IArmaModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.tramoseats.base.core.tramo.internal.ArmaModelSelector;
import jdplus.tramoseats.base.core.tramo.internal.TramoUtility;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ArmaModule
implements IArmaModule {
    private final boolean wn;
    private final boolean seasonal;

    public static Builder builder() {
        return new Builder();
    }

    static int comespa(int freq, int n, int inic, int d, int bd, boolean seas) {
        for (int i = inic; i > 1; --i) {
            if (!ArmaModule.checkespa(freq, n, i, d, bd, seas)) continue;
            return i;
        }
        return 0;
    }

    static boolean checkespa(int freq, int nz, int inic, int d, int bd, boolean seas) {
        SarimaOrders spec = ArmaModule.checkmaxspec(freq, inic, d, bd, seas);
        if (TramoUtility.autlar(nz, spec) < 0) {
            return false;
        }
        int n = nz - spec.getP() - spec.getPeriod() * spec.getBp();
        spec.setP(0);
        spec.setBp(0);
        return TramoUtility.autlar(n, spec) >= 0;
    }

    static SarimaOrders calcmaxspec(int freq, int inic, int d, int bd, boolean seas) {
        SarimaOrders spec = new SarimaOrders(freq);
        spec.setD(d);
        if (seas) {
            spec.setBd(bd);
        }
        switch (inic) {
            case 1: {
                spec.setP(1);
                spec.setQ(1);
                if (!seas) break;
                spec.setBp(1);
                spec.setBq(1);
                break;
            }
            case 2: {
                spec.setP(2);
                spec.setQ(2);
                if (!seas) break;
                spec.setBp(1);
                spec.setBq(1);
                break;
            }
            case 3: {
                spec.setP(3);
                spec.setQ(3);
                if (!seas) break;
                spec.setBp(1);
                spec.setBq(1);
                break;
            }
            case 4: {
                spec.setP(3);
                spec.setQ(3);
                spec.setBp(2);
                spec.setBq(2);
            }
        }
        return spec;
    }

    static int maxInic(int period) {
        return switch (period) {
            case 2 -> 1;
            case 3 -> 2;
            default -> 3;
        };
    }

    static SarimaOrders checkmaxspec(int freq, int inic, int d, int bd, boolean seas) {
        SarimaOrders spec = new SarimaOrders(freq);
        spec.setD(d);
        if (seas) {
            spec.setBd(bd);
        }
        switch (inic) {
            case 1: {
                spec.setP(1);
                spec.setQ(1);
                if (!seas) break;
                if (bd == 0) {
                    spec.setBp(1);
                }
                spec.setBq(1);
                break;
            }
            case 2: {
                spec.setP(2);
                spec.setQ(2);
                if (!seas) break;
                if (bd == 0) {
                    spec.setBp(1);
                }
                spec.setBq(1);
                break;
            }
            case 3: {
                spec.setP(3);
                spec.setQ(3);
                if (!seas) break;
                if (bd == 0) {
                    spec.setBp(1);
                }
                spec.setBq(1);
                break;
            }
            case 4: {
                spec.setP(3);
                spec.setQ(3);
                if (!seas) break;
                spec.setBp(2);
                spec.setBq(2);
            }
        }
        return spec;
    }

    private ArmaModule(Builder builder) {
        this.wn = builder.wn;
        this.seasonal = builder.seasonal;
    }

    private ArmaModelSelector createModule(SarimaOrders maxspec) {
        return ArmaModelSelector.builder().acceptWhiteNoise(this.wn).maxP(maxspec.getP()).maxQ(maxspec.getQ()).maxBp(maxspec.getBp()).maxBq(maxspec.getBq()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult process(RegSarimaModelling context) {
        ProcessingLog log = context.getLog();
        log.push("arma selection");
        try {
            ModelDescription desc = context.getDescription();
            SarimaOrders curspec = desc.specification();
            int inic = ArmaModule.comespa(curspec.getPeriod(), desc.regarima().getObservationsCount(), ArmaModule.maxInic(curspec.getPeriod()), curspec.getD(), curspec.getBd(), this.seasonal);
            if (inic == 0) {
                log.remark("default model selected (not enough obs.)");
                if (!curspec.isAirline(this.seasonal)) {
                    curspec.setDefault(this.seasonal);
                    desc.setSpecification(curspec);
                    ProcessingResult processingResult = ProcessingResult.Changed;
                    return processingResult;
                }
                ProcessingResult processingResult = ProcessingResult.Unprocessed;
                return processingResult;
            }
            SarimaOrders maxspec = ArmaModule.calcmaxspec(desc.getAnnualFrequency(), inic, curspec.getD(), curspec.getBd(), this.seasonal);
            DoubleSeq res = RegArimaUtility.olsResiduals((RegArimaModel)desc.regarima());
            ArmaModelSelector impl = this.createModule(maxspec);
            SarmaOrders nspec = impl.process(res, desc.getAnnualFrequency(), maxspec.getD(), maxspec.getBd(), this.seasonal);
            ArmaModelSelector.FastBIC[] models = impl.gePreferredModels();
            log.info("selected model: " + nspec.toString(), (Object)new CInfo(models, nspec));
            if (nspec.equals((Object)curspec.doStationary())) {
                ProcessingResult processingResult = ProcessingResult.Unchanged;
                return processingResult;
            }
            curspec = SarimaOrders.of((SarmaOrders)nspec, (int)curspec.getD(), (int)curspec.getBd());
            desc.setSpecification(curspec);
            ProcessingResult processingResult = ProcessingResult.Changed;
            return processingResult;
        }
        catch (RuntimeException ex) {
            log.remark("arma selection failed");
            ProcessingResult processingResult = ProcessingResult.Failed;
            return processingResult;
        }
        finally {
            log.pop();
        }
    }

    public SarimaOrders process(RegArimaModel<SarimaModel> regarima, boolean seas) {
        SarimaOrders curSpec = ((SarimaModel)regarima.arima()).orders();
        int inic = ArmaModule.comespa(curSpec.getPeriod(), regarima.getObservationsCount(), ArmaModule.maxInic(curSpec.getPeriod()), curSpec.getD(), curSpec.getBd(), seas);
        if (inic == 0) {
            curSpec.setDefault(seas);
            return curSpec;
        }
        SarimaOrders maxspec = ArmaModule.calcmaxspec(curSpec.getPeriod(), inic, curSpec.getD(), curSpec.getBd(), seas);
        DoubleSeq res = RegArimaUtility.olsResiduals(regarima);
        ArmaModelSelector impl = this.createModule(maxspec);
        SarmaOrders spec = impl.process(res, curSpec.getPeriod(), curSpec.getD(), curSpec.getBd(), curSpec.getPeriod() > 1);
        if (spec == null) {
            curSpec.setDefault(seas);
            return curSpec;
        }
        return SarimaOrders.of((SarmaOrders)spec, (int)curSpec.getD(), (int)curSpec.getBd());
    }

    public static class Builder {
        private boolean wn = false;
        private boolean seasonal = true;

        private Builder() {
        }

        public Builder acceptWhiteNoise(boolean ok) {
            this.wn = ok;
            return this;
        }

        public Builder seasonal(boolean seasonal) {
            this.seasonal = seasonal;
            return this;
        }

        public ArmaModule build() {
            return new ArmaModule(this);
        }
    }

    public static final class CInfo
    implements IArmaModule.Info {
        private final ArmaModelSelector.FastBIC[] models;
        private final SarmaOrders selection;

        public SarmaOrders bestModel() {
            return this.selection;
        }

        public SarmaOrders[] models() {
            SarmaOrders[] m = new SarmaOrders[this.models.length];
            for (int i = 0; i < m.length; ++i) {
                if (this.models[i] == null) continue;
                m[i] = this.models[i].getSpecification();
            }
            return m;
        }

        public double[] bic() {
            double[] d = new double[this.models.length];
            for (int i = 0; i < d.length; ++i) {
                d[i] = this.models[i] != null ? this.models[i].getBIC() : Double.NaN;
            }
            return d;
        }

        @Generated
        public CInfo(ArmaModelSelector.FastBIC[] models, SarmaOrders selection) {
            this.models = models;
            this.selection = selection;
        }

        @Generated
        public ArmaModelSelector.FastBIC[] getModels() {
            return this.models;
        }

        @Generated
        public SarmaOrders getSelection() {
            return this.selection;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CInfo)) {
                return false;
            }
            CInfo other = (CInfo)o;
            if (!Arrays.deepEquals(this.getModels(), other.getModels())) {
                return false;
            }
            SarmaOrders this$selection = this.getSelection();
            SarmaOrders other$selection = other.getSelection();
            return !(this$selection == null ? other$selection != null : !this$selection.equals(other$selection));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getModels());
            SarmaOrders $selection = this.getSelection();
            result = result * 59 + ($selection == null ? 43 : $selection.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "ArmaModule.CInfo(models=" + Arrays.deepToString(this.getModels()) + ", selection=" + String.valueOf(this.getSelection()) + ")";
        }
    }
}

