/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.seats;

import jdplus.toolkit.base.api.util.Validatable;
import jdplus.tramoseats.base.api.seats.DecompositionSpec;
import jdplus.tramoseats.base.api.seats.SeatsException;
import jdplus.tramoseats.base.api.seats.SeatsModelSpec;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SeatsSpec
implements Validatable<SeatsSpec> {
    private final SeatsModelSpec modelSpec;
    private final DecompositionSpec decompositionSpec;
    private static final SeatsSpec DEFAULT = (SeatsSpec)SeatsSpec.builder().build();

    public static Builder builder() {
        return new Builder().modelSpec(null).decompositionSpec(DecompositionSpec.DEFAULT);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    public SeatsSpec validate() throws IllegalArgumentException {
        this.decompositionSpec.validate();
        if (this.modelSpec != null) {
            this.modelSpec.validate();
            if (this.decompositionSpec.getMethod() != DecompositionSpec.ComponentsEstimationMethod.KalmanSmoother && this.modelSpec.getSeries().getValues().count(z -> !Double.isFinite(z)) > 0) {
                throw new SeatsException("Missing values are not allowed");
            }
        }
        return this;
    }

    @Generated
    SeatsSpec(SeatsModelSpec modelSpec, DecompositionSpec decompositionSpec) {
        this.modelSpec = modelSpec;
        this.decompositionSpec = decompositionSpec;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().modelSpec(this.modelSpec).decompositionSpec(this.decompositionSpec);
    }

    @Generated
    public SeatsModelSpec getModelSpec() {
        return this.modelSpec;
    }

    @Generated
    public DecompositionSpec getDecompositionSpec() {
        return this.decompositionSpec;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeatsSpec)) {
            return false;
        }
        SeatsSpec other = (SeatsSpec)o;
        SeatsModelSpec this$modelSpec = this.getModelSpec();
        SeatsModelSpec other$modelSpec = other.getModelSpec();
        if (this$modelSpec == null ? other$modelSpec != null : !((Object)this$modelSpec).equals(other$modelSpec)) {
            return false;
        }
        DecompositionSpec this$decompositionSpec = this.getDecompositionSpec();
        DecompositionSpec other$decompositionSpec = other.getDecompositionSpec();
        return !(this$decompositionSpec == null ? other$decompositionSpec != null : !((Object)this$decompositionSpec).equals(other$decompositionSpec));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SeatsModelSpec $modelSpec = this.getModelSpec();
        result = result * 59 + ($modelSpec == null ? 43 : ((Object)$modelSpec).hashCode());
        DecompositionSpec $decompositionSpec = this.getDecompositionSpec();
        result = result * 59 + ($decompositionSpec == null ? 43 : ((Object)$decompositionSpec).hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SeatsSpec(modelSpec=" + String.valueOf(this.getModelSpec()) + ", decompositionSpec=" + String.valueOf(this.getDecompositionSpec()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<SeatsSpec> {
        @Generated
        private SeatsModelSpec modelSpec;
        @Generated
        private DecompositionSpec decompositionSpec;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder modelSpec(SeatsModelSpec modelSpec) {
            this.modelSpec = modelSpec;
            return this;
        }

        @Generated
        public @NonNull Builder decompositionSpec(DecompositionSpec decompositionSpec) {
            this.decompositionSpec = decompositionSpec;
            return this;
        }

        @Generated
        public @NonNull SeatsSpec buildWithoutValidation() {
            return new SeatsSpec(this.modelSpec, this.decompositionSpec);
        }

        @Generated
        public @NonNull String toString() {
            return "SeatsSpec.Builder(modelSpec=" + String.valueOf(this.modelSpec) + ", decompositionSpec=" + String.valueOf(this.decompositionSpec) + ")";
        }
    }
}

