/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.Regression;
import jdplus.toolkit.base.core.regarima.RegArimaForecasts;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaProcessor;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;

public class CheckLast {
    private final RegSarimaProcessor kernel;
    private RegSarimaModel model;
    private final int nback;
    private TsData y;
    private TsData fy;
    private TsData oforecasts;
    private double[] f;
    private double[] ef;
    public static final int MAX_REPEAT_COUNT = 80;
    public static final int MAX_MISSING_COUNT = 33;

    public CheckLast(RegSarimaProcessor kernel, int nback) {
        this.kernel = kernel;
        this.nback = nback;
    }

    public boolean check(TsData data) {
        try {
            RegArimaForecasts.Result fcasts;
            this.clear();
            if (!this.testSeries(data)) {
                return false;
            }
            RegSarimaModel gmodel = this.kernel.process(data.drop(0, this.nback), null);
            if (gmodel == null || !(gmodel instanceof RegSarimaModel)) {
                return false;
            }
            this.model = gmodel;
            DoubleSeq b = this.model.getEstimation().getCoefficients();
            LikelihoodStatistics ll = this.model.getEstimation().getStatistics();
            double sig2 = ll.getSsqErr() / (double)(ll.getEffectiveObservationsCount() - ll.getEstimatedParametersCount());
            TsDomain edom = this.model.getEstimation().getDomain();
            if (b.isEmpty()) {
                fcasts = RegArimaForecasts.calcForecast(this.model.arima(), this.model.getEstimation().originalY(), this.nback, sig2);
            } else {
                Variable[] variables = this.model.getDescription().getVariables();
                TsDomain xdom = edom.extend(0, this.nback);
                FastMatrix matrix = Regression.matrix(xdom, (ITsVariable[])Arrays.stream(variables).map(v -> v.getCore()).toArray(ITsVariable[]::new));
                fcasts = RegArimaForecasts.calcForecast(this.model.arima(), this.model.getEstimation().originalY(), (Matrix)matrix, b, this.model.getEstimation().getCoefficientsCovariance(), sig2);
            }
            TsDomain fdom = TsDomain.of((TsPeriod)edom.getEndPeriod(), (int)this.nback);
            this.f = fcasts.getForecasts();
            this.ef = fcasts.getForecastsStdev();
            this.y = TsData.fitToDomain((TsData)data, (TsDomain)fdom);
            this.fy = this.model.transform(this.y, true);
            TsData tf = TsData.ofInternal((TsPeriod)fdom.getStartPeriod(), (double[])this.f);
            this.oforecasts = this.model.backTransform(tf, true);
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public RegSarimaModel getModel() {
        return this.model;
    }

    public DoubleSeq getRawValues() {
        return this.fy.getValues();
    }

    public DoubleSeq getActualValues() {
        return this.y.getValues();
    }

    public DoubleSeq getAbsoluteErrors() {
        return TsData.subtract((TsData)this.y, (TsData)this.oforecasts).getValues();
    }

    public DoubleSeq getForecastsValues() {
        return this.oforecasts.getValues();
    }

    public double[] getScores() {
        if (this.f == null || this.fy == null) {
            return null;
        }
        double[] s = new double[this.nback];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (this.fy.getValue(i) - this.f[i]) / this.ef[i];
        }
        return s;
    }

    public double[] getRelativeErrors() {
        return this.getScores();
    }

    public double getScore(int i) {
        if (this.f == null || this.fy == null) {
            return Double.NaN;
        }
        return (this.fy.getValue(i) - this.f[i]) / this.ef[i];
    }

    public double getRelativeError(int i) {
        return this.getScore(i);
    }

    public double[] getRawForecasts() {
        return this.f;
    }

    public double[] getRawForecastsStdev() {
        return this.ef;
    }

    public int getBackCount() {
        return this.nback;
    }

    public boolean testSeries(TsData y) {
        int ifreq;
        if (y == null) {
            return false;
        }
        int nz = y.length();
        if (nz < Math.max(8, 3 * (ifreq = y.getAnnualFrequency()))) {
            return false;
        }
        int nrepeat = y.getValues().getRepeatCount();
        if (nrepeat > 80 * nz / 100) {
            return false;
        }
        int nm = y.getValues().count(z -> !Double.isFinite(z));
        return nm <= 33 * nz / 100;
    }

    private void clear() {
        this.model = null;
        this.f = null;
        this.ef = null;
        this.fy = null;
    }
}

