/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp;

import internal.toolkit.base.tsp.InternalTsProvider;
import java.io.File;
import java.io.FileNotFoundException;
import jdplus.toolkit.base.tsp.fixme.Files2;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public interface HasFilePaths {
    public void setPaths(@Nullable File[] var1);

    @NonNull
    public File[] getPaths();

    @NonNull
    default public File resolveFilePath(@NonNull File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        File result = Files2.getAbsoluteFile(this.getPaths(), file);
        if (result == null) {
            throw new FileNotFoundException("Relative file '" + file.getPath() + "' outside paths");
        }
        if (!result.exists()) {
            throw new FileNotFoundException(result.getPath());
        }
        return result;
    }

    @NonNull
    public static HasFilePaths of() {
        return new InternalTsProvider.FilePathSupport(() -> {});
    }

    @NonNull
    public static HasFilePaths of(@NonNull Runnable onPathsChange) {
        if (onPathsChange == null) {
            throw new NullPointerException("onPathsChange is marked non-null but is null");
        }
        return new InternalTsProvider.FilePathSupport(onPathsChange);
    }
}

