## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## -----------------------------------------------------------------------------
# library(egnyte)
# 
# # Authenticate (assuming you've set up environment variables)
# eg_auth()

## -----------------------------------------------------------------------------
# # Download a file to a specific location
# eg_read("/Shared/Documents/report.pdf", destfile = "local_report.pdf")

## -----------------------------------------------------------------------------
# # Download to a temp file
# temp_path <- eg_read("/Shared/Documents/report.pdf")
# 
# # The file is now at temp_path
# print(temp_path)
# #> [1] "/var/folders/.../file123.pdf"

## -----------------------------------------------------------------------------
# # A file in a shared folder
# eg_read("/Shared/Data/analysis/results.csv", destfile = "results.csv")
# 
# # A file in a nested folder
# eg_read("/Shared/Projects/2024/Q1/report.docx", destfile = "report.docx")
# 
# # A file in your private folder
# eg_read("/Private/jsmith/notes.txt", destfile = "notes.txt")

## -----------------------------------------------------------------------------
# # Upload a file
# eg_write("local_report.pdf", path = "/Shared/Documents/report.pdf")

## -----------------------------------------------------------------------------
# # This will error if the file already exists
# eg_write("report.pdf", path = "/Shared/Documents/report.pdf")
# #> Error: File already exists at /Shared/Documents/report.pdf
# #> Use overwrite = TRUE to replace it

## -----------------------------------------------------------------------------
# # Replace existing file
# eg_write("report.pdf", path = "/Shared/Documents/report.pdf", overwrite = TRUE)

## -----------------------------------------------------------------------------
# # This works even if the "2024/Q1" folders don't exist yet
# eg_write("report.pdf", path = "/Shared/Projects/2024/Q1/report.pdf")

## -----------------------------------------------------------------------------
# # List files in a directory
# files <- eg_list("/Shared/Documents")
# files
# #> [1] "/Shared/Documents/report.pdf"
# #> [2] "/Shared/Documents/notes.txt"
# #> [3] "/Shared/Documents/data.csv"

## -----------------------------------------------------------------------------
# # List all files, including those in subdirectories
# all_files <- eg_list("/Shared/Projects", recursive = TRUE)
# all_files
# #> [1] "/Shared/Projects/readme.txt"
# #> [2] "/Shared/Projects/2024/Q1/report.pdf"
# #> [3] "/Shared/Projects/2024/Q1/data.xlsx"
# #> [4] "/Shared/Projects/2024/Q2/summary.docx"

## -----------------------------------------------------------------------------
# # Get only CSV files
# all_files <- eg_list("/Shared/Data", recursive = TRUE)
# csv_files <- all_files[grepl("\\.csv$", all_files)]
# 
# # Get files matching a pattern
# reports <- all_files[grepl("report", all_files, ignore.case = TRUE)]

## -----------------------------------------------------------------------------
# # Find all Excel files in a project folder
# files <- eg_list("/Shared/Projects/2024", recursive = TRUE)
# excel_files <- files[grepl("\\.xlsx$", files)]
# 
# # Download each one
# for (f in excel_files) {
#   local_name <- basename(f)
#   eg_read(f, destfile = file.path("downloads", local_name))
# }

## -----------------------------------------------------------------------------
# # Download the raw data
# eg_read("/Shared/Data/raw_data.xlsx", destfile = "raw_data.xlsx")
# 
# # ... do your processing ...
# # (maybe using readxl to read it, process with dplyr, write with writexl)
# 
# # Upload the processed result
# eg_write("processed_data.xlsx", path = "/Shared/Data/processed_data.xlsx")

## -----------------------------------------------------------------------------
# # Files to download
# files <- c(
#   "/Shared/Data/file1.csv",
#   "/Shared/Data/file2.csv",
#   "/Shared/Data/file3.csv"
# )
# 
# # Download each to a local folder
# for (f in files) {
#   local_name <- basename(f)
#   eg_read(f, destfile = file.path("downloads", local_name))
# }

## -----------------------------------------------------------------------------
# safe_upload <- function(local_file, egnyte_path, overwrite = FALSE) {
#   tryCatch(
#     eg_write(local_file, path = egnyte_path, overwrite = overwrite),
#     error = function(e) {
#       if (grepl("already exists", e$message)) {
#         message("File exists. Use overwrite = TRUE to replace.")
#       } else {
#         stop(e)
#       }
#     }
#   )
# }

