/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.IMovingHolidayVariable;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.IUserVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModifiedTsVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import lombok.Generated;

public final class ModellingUtility {
    public static final String AMI = "ami";
    public static final String AMI_PREVIOUS = "ami_previous";

    public static boolean isAutomaticallyIdentified(Variable var) {
        return var.hasAttribute(AMI);
    }

    public static boolean isOutlier(Variable var) {
        return var.getCore() instanceof IOutlier;
    }

    public static boolean isOutlier(Variable var, boolean ami) {
        if (var.getCore() instanceof IOutlier) {
            return ami == var.hasAttribute(AMI);
        }
        return false;
    }

    public static boolean isMovingHoliday(Variable var) {
        if (var.getCore() instanceof IMovingHolidayVariable) {
            return true;
        }
        if (var.getCore() instanceof ModifiedTsVariable) {
            ModifiedTsVariable mvar = (ModifiedTsVariable)var.getCore();
            return mvar.getVariable() instanceof IMovingHolidayVariable;
        }
        return false;
    }

    public static boolean isEaster(Variable var) {
        if (var.getCore() instanceof IEasterVariable) {
            return true;
        }
        if (var.getCore() instanceof ModifiedTsVariable) {
            ModifiedTsVariable mvar = (ModifiedTsVariable)var.getCore();
            return mvar.getVariable() instanceof IEasterVariable;
        }
        return false;
    }

    public static boolean isTradingDays(Variable var) {
        if (var.getCore() instanceof ITradingDaysVariable) {
            return true;
        }
        if (var.getCore() instanceof ModifiedTsVariable) {
            ModifiedTsVariable mvar = (ModifiedTsVariable)var.getCore();
            return mvar.getVariable() instanceof ITradingDaysVariable;
        }
        return false;
    }

    public static boolean isLengthOfPeriod(Variable var) {
        if (var.getCore() instanceof ILengthOfPeriodVariable) {
            return true;
        }
        if (var.getCore() instanceof ModifiedTsVariable) {
            ModifiedTsVariable mvar = (ModifiedTsVariable)var.getCore();
            return mvar.getVariable() instanceof ILengthOfPeriodVariable;
        }
        return false;
    }

    public static boolean isDaysRelated(Variable var) {
        return ModellingUtility.isTradingDays(var) || ModellingUtility.isLengthOfPeriod(var);
    }

    public static boolean isCalendar(Variable var) {
        return ModellingUtility.isTradingDays(var) || ModellingUtility.isLengthOfPeriod(var) || ModellingUtility.isMovingHoliday(var);
    }

    public static boolean isUser(Variable var) {
        if (var.getCore() instanceof IUserVariable) {
            return true;
        }
        if (var.getCore() instanceof ModifiedTsVariable) {
            ModifiedTsVariable mvar = (ModifiedTsVariable)var.getCore();
            return mvar.getVariable() instanceof IUserVariable;
        }
        return false;
    }

    @Generated
    private ModellingUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

