/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.data;

import internal.toolkit.base.api.data.InternalSeq;
import internal.toolkit.base.api.data.InternalSeqCursor;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.api.data.BaseSeq;
import jdplus.toolkit.base.api.data.SeqCursor;
import lombok.NonNull;

public interface Seq<E>
extends BaseSeq,
Iterable<E> {
    public E get(int var1) throws IndexOutOfBoundsException;

    @Override
    @NonNull
    default public SeqCursor<E> cursor() {
        return new InternalSeqCursor.DefaultSeqCursor(this);
    }

    @Override
    default public Iterator<E> iterator() {
        return new InternalSeq.SequenceIterator(this);
    }

    @Override
    default public void forEach(Consumer<? super E> action) {
        InternalSeq.forEach(this, action);
    }

    @Override
    default public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 0);
    }

    @NonNull
    default public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @NonNull
    default public E[] toArray(@NonNull IntFunction<E[]> generator) {
        if (generator == null) {
            throw new NullPointerException("generator is marked non-null but is null");
        }
        return InternalSeq.toArray(this, generator);
    }

    @NonNull
    default public List<E> toList() {
        return InternalSeq.toList(this);
    }

    default public int indexOf(@NonNull Predicate<? super E> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        return InternalSeq.firstIndexOf(this, predicate);
    }
}

