/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.timeseries.util;

import internal.toolkit.base.api.timeseries.util.GuessingUnit;
import internal.toolkit.base.api.timeseries.util.ObsList;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntUnaryOperator;
import jdplus.toolkit.base.api.data.AggregationType;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import lombok.Generated;

final class TsDataCollector {
    public static TsData makeWithAggregation(ObsList obs, TsUnit unit, LocalDateTime reference, AggregationType convMode) {
        int n = obs.size();
        if (n == 0) {
            return null;
        }
        obs.sortByPeriod();
        IntUnaryOperator toPeriodId = obs.getPeriodIdFunc(unit, reference);
        double[] vals = new double[n];
        int[] ids = new int[n];
        int ncur = -1;
        int avn = 0;
        block8: for (int i = 0; i < n; ++i) {
            int curid = toPeriodId.applyAsInt(i);
            double value = obs.getValue(i);
            switch (convMode) {
                case Average: {
                    if (!Double.isFinite(value)) continue block8;
                    if (TsDataCollector.isNewPeriod(ncur, curid, ids)) {
                        if (ncur >= 0) {
                            int n2 = ncur;
                            vals[n2] = vals[n2] / (double)avn;
                        }
                        vals[++ncur] = value;
                        ids[ncur] = curid;
                        avn = 1;
                        continue block8;
                    }
                    int n3 = ncur;
                    vals[n3] = vals[n3] + value;
                    ++avn;
                    continue block8;
                }
                case Sum: {
                    if (!Double.isFinite(value)) continue block8;
                    if (TsDataCollector.isNewPeriod(ncur, curid, ids)) {
                        vals[++ncur] = value;
                        ids[ncur] = curid;
                        continue block8;
                    }
                    int n4 = ncur;
                    vals[n4] = vals[n4] + value;
                    continue block8;
                }
                case First: {
                    if (!Double.isFinite(value) || !TsDataCollector.isNewPeriod(ncur, curid, ids)) continue block8;
                    vals[++ncur] = value;
                    ids[ncur] = curid;
                    continue block8;
                }
                case Last: {
                    if (!Double.isFinite(value)) continue block8;
                    if (TsDataCollector.isNewPeriod(ncur, curid, ids)) {
                        ids[++ncur] = curid;
                    }
                    vals[ncur] = value;
                    continue block8;
                }
                case Max: {
                    if (!Double.isFinite(value)) continue block8;
                    if (TsDataCollector.isNewPeriod(ncur, curid, ids)) {
                        vals[++ncur] = value;
                        ids[ncur] = curid;
                        continue block8;
                    }
                    double dcur = value;
                    if (!(dcur > vals[ncur])) continue block8;
                    vals[ncur] = dcur;
                    continue block8;
                }
                case Min: {
                    if (!Double.isFinite(value)) continue block8;
                    if (TsDataCollector.isNewPeriod(ncur, curid, ids)) {
                        vals[++ncur] = value;
                        ids[ncur] = curid;
                        continue block8;
                    }
                    double dcur = value;
                    if (!(dcur < vals[ncur])) continue block8;
                    vals[ncur] = dcur;
                }
            }
        }
        if (convMode == AggregationType.Average && ncur >= 0) {
            int n5 = ncur;
            vals[n5] = vals[n5] / (double)avn;
        }
        int firstId = ids[0];
        int lastId = ids[ncur];
        TsPeriod start = TsPeriod.of(unit, firstId);
        int l = lastId - firstId + 1;
        if (l == ncur + 1) {
            return TsData.ofInternal(start, ncur + 1 == n ? vals : Arrays.copyOf(vals, ncur + 1));
        }
        return TsData.of(start, TsDataCollector.expand(ncur + 1, l, ids, o -> vals[o]));
    }

    private static boolean isNewPeriod(int ncur, int curid, int[] ids) {
        return ncur < 0 || curid != ids[ncur];
    }

    public static TsData makeFromUnknownUnit(ObsList obs) {
        int size = obs.size();
        if (size < 2) {
            return null;
        }
        obs.sortByPeriod();
        int[] ids = new int[size];
        GuessingUnit guess = TsDataCollector.makeIds(obs, ids);
        if (guess == null) {
            return null;
        }
        int firstId = ids[0];
        int lastId = ids[size - 1];
        TsPeriod start = guess.atId(firstId);
        int expectedSize = lastId - firstId + 1;
        if (expectedSize == size) {
            return TsData.of(start, obs.getValues());
        }
        return TsData.of(start, TsDataCollector.expand(size, expectedSize, ids, obs::getValue));
    }

    private static GuessingUnit makeIds(ObsList obs, int[] ids) {
        for (GuessingUnit o : GuessingUnit.values()) {
            if (!TsDataCollector.makeIdsFromUnit(obs, ids, o)) continue;
            return o;
        }
        return null;
    }

    private static boolean makeIdsFromUnit(ObsList obs, int[] ids, GuessingUnit guess) {
        if (obs.size() < guess.getMinimumObsCount()) {
            return false;
        }
        IntUnaryOperator toPeriodId = obs.getPeriodIdFunc(guess.getTsUnit(), guess.getReference());
        ids[0] = toPeriodId.applyAsInt(0);
        for (int i = 1; i < ids.length; ++i) {
            ids[i] = toPeriodId.applyAsInt(i);
            if (ids[i] != ids[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static TsData makeWithoutAggregation(ObsList obs, TsUnit unit, LocalDateTime reference) {
        int size = obs.size();
        if (size == 0) {
            return null;
        }
        obs.sortByPeriod();
        IntUnaryOperator toPeriodId = obs.getPeriodIdFunc(unit, reference);
        int[] ids = new int[size];
        ids[0] = toPeriodId.applyAsInt(0);
        for (int i = 1; i < size; ++i) {
            ids[i] = toPeriodId.applyAsInt(i);
            if (ids[i] != ids[i - 1]) continue;
            return null;
        }
        int firstId = ids[0];
        int lastId = ids[size - 1];
        TsPeriod start = TsPeriod.of(unit, firstId);
        int expectedSize = lastId - firstId + 1;
        if (expectedSize == size) {
            return TsData.of(start, obs.getValues());
        }
        return TsData.of(start, TsDataCollector.expand(size, expectedSize, ids, obs::getValue));
    }

    private static DoubleSeq expand(int currentSize, int expectedSize, int[] ids, IntToDoubleFunction valueFunc) {
        double[] safeArray = new double[expectedSize];
        Arrays.fill(safeArray, Double.NaN);
        safeArray[0] = valueFunc.applyAsDouble(0);
        for (int j = 1; j < currentSize; ++j) {
            safeArray[ids[j] - ids[0]] = valueFunc.applyAsDouble(j);
        }
        return DoubleSeq.of(safeArray);
    }

    @Generated
    private TsDataCollector() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

