/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.protobuf.regarima;

import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.data.Iterables;
import jdplus.toolkit.base.api.data.ParametersEstimation;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.IEasterVariable;
import jdplus.toolkit.base.api.timeseries.regression.ILengthOfPeriodVariable;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.MissingValueEstimation;
import jdplus.toolkit.base.api.timeseries.regression.Ramp;
import jdplus.toolkit.base.api.timeseries.regression.TrendConstant;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import jdplus.toolkit.base.core.stats.likelihood.LogLikelihoodFunction;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtos;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtosUtility;
import jdplus.toolkit.base.protobuf.regarima.RegArimaProtos;
import jdplus.toolkit.base.protobuf.regarima.RegArimaProtosUtility;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtos;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtosUtility;
import lombok.Generated;

public final class RegArimaEstimationProto {
    public static RegArimaProtos.RegArimaModel.Description convert(GeneralLinearModel.Description<SarimaSpec> description) {
        RegArimaProtos.RegArimaModel.Description.Builder builder = RegArimaProtos.RegArimaModel.Description.newBuilder();
        TsDomain domain = description.getSeries().getDomain();
        Variable[] vars = description.getVariables();
        for (int i = 0; i < vars.length; ++i) {
            Variable vari = vars[i];
            int m = vari.dim();
            ITsVariable core = vari.getCore();
            ModellingProtos.VariableType type = RegArimaEstimationProto.type(core);
            ModellingProtos.RegressionVariable.Builder vbuilder = ModellingProtos.RegressionVariable.newBuilder().setName(vari.getName()).setVarType(type).putAllMetadata(vars[i].getAttributes());
            for (int k = 0; k < m; ++k) {
                String pname = m == 1 ? vari.getName() : vari.getCore().description(k, (TimeSeriesDomain)domain);
                vbuilder.addCoefficients(ToolkitProtosUtility.convert(vari.getCoefficient(k), pname));
            }
            builder.addVariables(vbuilder.build());
        }
        return builder.setSeries(ToolkitProtosUtility.convert(description.getSeries())).setPreadjustment(ModellingProtosUtility.convert(description.getLengthOfPeriodTransformation())).setLog(description.isLogTransformation()).setArima(RegArimaProtosUtility.convert((SarimaSpec)description.getStochasticComponent())).build();
    }

    public static RegArimaProtos.RegArimaModel.Estimation convert(GeneralLinearModel.Estimation estimation, DoubleSeq res) {
        RegArimaProtos.RegArimaModel.Estimation.Builder builder = RegArimaProtos.RegArimaModel.Estimation.newBuilder();
        Matrix cov = estimation.getCoefficientsCovariance();
        LikelihoodStatistics statistics = estimation.getStatistics();
        builder.addAllY(Iterables.of((DoubleSeq)estimation.getY())).setX(ToolkitProtosUtility.convert(estimation.getX())).setParameters(ToolkitProtosUtility.convert(estimation.getParameters())).setLikelihood(ToolkitProtosUtility.convert(statistics)).addAllB(Iterables.of((DoubleSeq)estimation.getCoefficients())).setBcovariance(ToolkitProtosUtility.convert(cov)).addAllResiduals(Iterables.of((DoubleSeq)res));
        MissingValueEstimation[] missing = estimation.getMissing();
        if (missing.length > 0) {
            for (int i = 0; i < missing.length; ++i) {
                builder.addMissings(RegArimaEstimationProto.convert(missing[i]));
            }
        }
        return builder.build();
    }

    public static RegArimaProtos.RegArimaModel.Estimation convert(RegArimaEstimation<SarimaModel> estimation) {
        RegArimaProtos.RegArimaModel.Estimation.Builder builder = RegArimaProtos.RegArimaModel.Estimation.newBuilder();
        FastMatrix cov = estimation.getConcentratedLikelihood().covariance(estimation.parametersCount(), true);
        LikelihoodStatistics statistics = estimation.statistics();
        RegArimaModel model = estimation.getModel();
        LogLikelihoodFunction.Point max = estimation.getMax();
        ParametersEstimation pestim = max == null ? new ParametersEstimation((DoubleSeq)Doubles.EMPTY, (Matrix)FastMatrix.EMPTY, (DoubleSeq)Doubles.EMPTY, null) : new ParametersEstimation(max.getParameters(), (Matrix)max.asymptoticCovariance(), max.getScore(), "sarima (true signs)");
        builder.addAllY(Iterables.of((DoubleSeq)model.getY())).setX(ToolkitProtosUtility.convert((Matrix)model.variables())).setParameters(ToolkitProtosUtility.convert(pestim)).setLikelihood(ToolkitProtosUtility.convert(statistics)).addAllB(Iterables.of((DoubleSeq)estimation.getConcentratedLikelihood().coefficients())).setBcovariance(ToolkitProtosUtility.convert((Matrix)cov)).addAllResiduals(Iterables.of((DoubleSeq)estimation.getConcentratedLikelihood().e()));
        return builder.build();
    }

    public static RegArimaProtos.RegArimaModel convert(RegSarimaModel model) {
        if (model == null) {
            return RegArimaProtos.RegArimaModel.newBuilder().build();
        }
        DoubleSeq res = model.fullResiduals().getValues();
        return RegArimaProtos.RegArimaModel.newBuilder().setDescription(RegArimaEstimationProto.convert((GeneralLinearModel.Description<SarimaSpec>)model.getDescription())).setEstimation(RegArimaEstimationProto.convert(model.getEstimation(), res)).setDiagnostics(RegArimaEstimationProto.diagnosticsOf((GeneralLinearModel<SarimaSpec>)model)).build();
    }

    public static ModellingProtos.MissingEstimation convert(MissingValueEstimation missing) {
        return ModellingProtos.MissingEstimation.newBuilder().setPosition(missing.getPosition()).setValue(missing.getValue()).setStde(missing.getStandardError()).build();
    }

    public static ModellingProtos.Diagnostics diagnosticsOf(GeneralLinearModel<SarimaSpec> model) {
        ModellingProtos.Diagnostics.Builder builder = ModellingProtos.Diagnostics.newBuilder();
        model.getResiduals().getTests().forEach((k, v) -> {
            StatisticalTest st;
            if (v instanceof StatisticalTest && (st = v).isValid()) {
                ToolkitProtos.StatisticalTest test = ToolkitProtosUtility.convert(st);
                builder.putResidualsTests((String)k, test);
            }
        });
        return builder.build();
    }

    public static ModellingProtos.VariableType type(ITsVariable var) {
        if (var instanceof TrendConstant) {
            return ModellingProtos.VariableType.VAR_MEAN;
        }
        if (var instanceof ITradingDaysVariable) {
            return ModellingProtos.VariableType.VAR_TD;
        }
        if (var instanceof ILengthOfPeriodVariable) {
            return ModellingProtos.VariableType.VAR_LP;
        }
        if (var instanceof IEasterVariable) {
            return ModellingProtos.VariableType.VAR_EASTER;
        }
        if (var instanceof IOutlier) {
            switch (((IOutlier)var).getCode()) {
                case "AO": {
                    return ModellingProtos.VariableType.VAR_AO;
                }
                case "LS": {
                    return ModellingProtos.VariableType.VAR_LS;
                }
                case "TC": {
                    return ModellingProtos.VariableType.VAR_TC;
                }
                case "SO": 
                case "PO": {
                    return ModellingProtos.VariableType.VAR_SO;
                }
            }
            return ModellingProtos.VariableType.VAR_OUTLIER;
        }
        if (var instanceof InterventionVariable) {
            return ModellingProtos.VariableType.VAR_IV;
        }
        if (var instanceof Ramp) {
            return ModellingProtos.VariableType.VAR_RAMP;
        }
        return ModellingProtos.VariableType.VAR_UNSPECIFIED;
    }

    @Generated
    private RegArimaEstimationProto() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

