/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp.util;

import internal.toolkit.base.tsp.util.MapCache;
import java.time.Duration;
import java.util.Map;
import java.util.function.LongSupplier;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TtlMapCache<K, V>
implements MapCache<K, V> {
    @NonNull
    private final Map<K, Entry<V>> map;
    @NonNull
    private final LongSupplier ticker;
    @NonNull
    private final Duration ttl;

    @Override
    public void put(@NonNull K key, @NonNull V value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.map.put(key, new Entry<V>(value, this.ticker.getAsLong()));
    }

    @Override
    public @Nullable V get(@NonNull K key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Entry<V> result = this.map.get(key);
        if (result == null) {
            return null;
        }
        if (!this.validate(result.creationTime())) {
            this.map.remove(key);
            return null;
        }
        return result.value();
    }

    private boolean validate(long creationTime) {
        return this.ticker.getAsLong() < creationTime + this.ttl.toNanos();
    }

    @Override
    @NonNull
    @Generated
    public Map<K, Entry<V>> getMap() {
        return this.map;
    }

    @NonNull
    @Generated
    public LongSupplier getTicker() {
        return this.ticker;
    }

    @NonNull
    @Generated
    public Duration getTtl() {
        return this.ttl;
    }

    @Generated
    public TtlMapCache(@NonNull Map<K, Entry<V>> map, @NonNull LongSupplier ticker, @NonNull Duration ttl) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (ticker == null) {
            throw new NullPointerException("ticker is marked non-null but is null");
        }
        if (ttl == null) {
            throw new NullPointerException("ttl is marked non-null but is null");
        }
        this.map = map;
        this.ticker = ticker;
        this.ttl = ttl;
    }

    public record Entry<V>(@NonNull V value, long creationTime) {
        @Generated
        public Entry(@NonNull V value, long creationTime) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
        }
    }
}

