/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.dita.dost.platform.ExtensionPoint;
import org.dita.dost.platform.Plugin;
import org.dita.dost.platform.PluginParser;
import org.dita.dost.platform.PluginRequirement;
import org.dita.dost.platform.SemVer;
import org.dita.dost.platform.Value;
import org.dita.dost.util.FileUtils;
import org.w3c.dom.Element;

record Features(String pluginId, SemVer pluginVersion, File pluginDir, File ditaDir, List<ExtensionPoint> extensionPoints, Map<String, List<Value>> features, List<PluginRequirement> requiredPlugins, Map<String, String> metaTable, List<String> templates) implements Plugin
{
    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private String pluginId;
        private SemVer pluginVersion;
        private File pluginDir;
        private File ditaDir;
        private final List<ExtensionPoint> extensionPoints = new ArrayList<ExtensionPoint>();
        private final Map<String, List<Value>> featureTable = new HashMap<String, List<Value>>();
        private final List<PluginRequirement> requireList = new ArrayList<PluginRequirement>();
        private final Map<String, String> metaTable = new HashMap<String, String>();
        private final List<String> templateList = new ArrayList<String>();

        public Features build() {
            return new Features(this.pluginId, this.pluginVersion, this.pluginDir, this.ditaDir, List.copyOf(this.extensionPoints), this.featureTable.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> List.copyOf((Collection)entry.getValue()))), List.copyOf(this.requireList), Map.copyOf(this.metaTable), List.copyOf(this.templateList));
        }

        Builder setPluginId(String id) {
            if (!PluginParser.ID_PATTERN.matcher(id).matches()) {
                throw new IllegalArgumentException("Plug-in ID '%s' doesn't follow syntax rules.".formatted(id));
            }
            this.pluginId = id;
            return this;
        }

        Builder addExtensionPoint(String extensionPointId, String name) {
            this.extensionPoints.add(new ExtensionPoint(extensionPointId, name));
            return this;
        }

        Builder addFeature(String featureId, Element elem) {
            boolean isFile;
            String value = elem.getAttribute("file");
            if (!value.isEmpty()) {
                isFile = true;
            } else {
                value = elem.getAttribute("value");
                isFile = "file".equals(elem.getAttribute("type"));
            }
            StringTokenizer valueTokenizer = new StringTokenizer(value, ",");
            ArrayList<Record> valueBuffer = new ArrayList<Record>();
            if (this.featureTable.containsKey(featureId)) {
                valueBuffer.addAll((Collection)this.featureTable.get(featureId));
            }
            while (valueTokenizer.hasMoreElements()) {
                String valueElement = valueTokenizer.nextToken();
                if (valueElement == null || valueElement.trim().length() == 0) continue;
                if (isFile && !FileUtils.isAbsolutePath(valueElement)) {
                    if (featureId.equals("ant.import")) {
                        valueBuffer.add(new Value.PathValue(this.pluginId, this.pluginDir, valueElement.trim()));
                        continue;
                    }
                    valueBuffer.add(new Value.PathValue(this.pluginId, this.pluginDir, valueElement.trim()));
                    continue;
                }
                if (featureId.equals("package.version")) {
                    this.setPluginVersion(valueElement.trim());
                }
                valueBuffer.add(new Value.StringValue(this.pluginId, valueElement.trim()));
            }
            this.featureTable.put(featureId, valueBuffer);
            return this;
        }

        public Builder setPluginVersion(String pluginVersion) {
            this.pluginVersion = new SemVer(pluginVersion);
            return this;
        }

        Builder addRequire(String id) {
            PluginRequirement.Builder requirement = PluginRequirement.builder().addPlugins(id);
            this.requireList.add(requirement.build());
            return this;
        }

        Builder addRequire(String id, String importance) {
            PluginRequirement.Builder requirement = PluginRequirement.builder();
            requirement.addPlugins(id);
            if (importance != null) {
                requirement.setRequired(importance.equals("required"));
            }
            this.requireList.add(requirement.build());
            return this;
        }

        Builder addMeta(String type, String value) {
            this.metaTable.put(type, Objects.requireNonNull(value));
            return this;
        }

        Builder addTemplate(String file) {
            this.templateList.add(file);
            return this;
        }

        public Builder setDitaDir(File ditaDir) {
            if (!ditaDir.isAbsolute()) {
                throw new IllegalArgumentException("Installation base directory must be absolute: " + this.pluginDir.toString());
            }
            this.ditaDir = ditaDir;
            return this;
        }

        public Builder setPluginDir(File pluginDir) {
            if (!pluginDir.isAbsolute()) {
                throw new IllegalArgumentException("Plug-in directory must be absolute: " + pluginDir.toString());
            }
            this.pluginDir = pluginDir;
            return this;
        }
    }
}

